/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.mom.api;

import java.util.Collections;
import java.util.Map;
import org.eclipse.scout.rt.mom.api.IBiDestination;
import org.eclipse.scout.rt.mom.api.IDestination;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;

class Destination<REQUEST, REPLY>
implements IBiDestination<REQUEST, REPLY> {
    private final String m_name;
    private final IDestination.IDestinationType m_type;
    private final IDestination.IResolveMethod m_resolveMethod;
    private final Map<String, String> m_properties;

    public Destination(String name, IDestination.IDestinationType type, IDestination.IResolveMethod resolveMethod, Map<String, String> properties) {
        this.m_name = Assertions.assertNotNullOrEmpty((String)name, (String)"destination name not specified", (Object[])new Object[0]);
        this.m_type = (IDestination.IDestinationType)Assertions.assertNotNull((Object)type, (String)"destination type not specified", (Object[])new Object[0]);
        this.m_resolveMethod = (IDestination.IResolveMethod)Assertions.assertNotNull((Object)resolveMethod, (String)"resolve method not specified", (Object[])new Object[0]);
        this.m_properties = properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(properties);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public IDestination.IDestinationType getType() {
        return this.m_type;
    }

    @Override
    public IDestination.IResolveMethod getResolveMethod() {
        return this.m_resolveMethod;
    }

    public Map<String, String> getProperties() {
        return this.m_properties;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Destination other = (Destination)obj;
        return !(this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name));
    }

    public String toString() {
        return new ToStringBuilder((Object)this).attr("name", this.m_name).attr("type", (Object)this.m_type).attr("resolveMethod", (Object)this.m_resolveMethod).attr("properties", this.m_properties).toString();
    }
}

