/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.mom.api;

import java.util.Map;
import org.eclipse.scout.rt.mom.api.Destination;
import org.eclipse.scout.rt.mom.api.IBiDestination;
import org.eclipse.scout.rt.mom.api.IDestination;
import org.eclipse.scout.rt.mom.api.IMessageListener;
import org.eclipse.scout.rt.mom.api.IMomTransport;
import org.eclipse.scout.rt.mom.api.IRequestListener;
import org.eclipse.scout.rt.mom.api.ISubscription;
import org.eclipse.scout.rt.mom.api.PublishInput;
import org.eclipse.scout.rt.mom.api.SubscribeInput;
import org.eclipse.scout.rt.mom.api.marshaller.IMarshaller;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.IRegistrationHandle;

public final class MOM {
    private MOM() {
    }

    public static <DTO> IDestination<DTO> newDestination(String name, IDestination.IDestinationType destinationType, IDestination.IResolveMethod resolveMethod, Map<String, String> properties) {
        return new Destination(name, destinationType, resolveMethod, properties);
    }

    public static <REQUEST, REPLY> IBiDestination<REQUEST, REPLY> newBiDestination(String name, IDestination.IDestinationType destinationType, IDestination.IResolveMethod resolveMethod, Map<String, String> properties) {
        return new Destination(name, destinationType, resolveMethod, properties);
    }

    public static PublishInput newPublishInput() {
        return (PublishInput)BEANS.get(PublishInput.class);
    }

    public static SubscribeInput newSubscribeInput() {
        return (SubscribeInput)BEANS.get(SubscribeInput.class);
    }

    public static <DTO> void publish(Class<? extends IMomTransport> transport, IDestination<DTO> destination, DTO transferObject) {
        MOM.publish(transport, destination, transferObject, null);
    }

    public static <DTO> void publish(Class<? extends IMomTransport> transport, IDestination<DTO> destination, DTO transferObject, PublishInput input) {
        ((IMomTransport)BEANS.get(transport)).publish(destination, transferObject, input != null ? input : MOM.newPublishInput());
    }

    public static <DTO> ISubscription subscribe(Class<? extends IMomTransport> transport, IDestination<DTO> destination, IMessageListener<DTO> listener) {
        return MOM.subscribe(transport, destination, listener, null);
    }

    public static <DTO> ISubscription subscribe(Class<? extends IMomTransport> transport, IDestination<DTO> destination, IMessageListener<DTO> listener, SubscribeInput input) {
        return ((IMomTransport)BEANS.get(transport)).subscribe(destination, listener, input != null ? input : MOM.newSubscribeInput());
    }

    public static void cancelDurableSubscription(Class<? extends IMomTransport> transport, String durableSubscriptionName) {
        ((IMomTransport)BEANS.get(transport)).cancelDurableSubscription(durableSubscriptionName);
    }

    public static <REQUEST, REPLY> REPLY request(Class<? extends IMomTransport> transport, IBiDestination<REQUEST, REPLY> destination, REQUEST requestObject) {
        return ((IMomTransport)BEANS.get(transport)).request(destination, requestObject, MOM.newPublishInput());
    }

    public static <REQUEST, REPLY> REPLY request(Class<? extends IMomTransport> transport, IBiDestination<REQUEST, REPLY> destination, REQUEST requestObject, PublishInput input) {
        return ((IMomTransport)BEANS.get(transport)).request(destination, requestObject, input);
    }

    public static <REQUEST, REPLY> ISubscription reply(Class<? extends IMomTransport> transport, IBiDestination<REQUEST, REPLY> destination, IRequestListener<REQUEST, REPLY> listener) {
        return MOM.reply(transport, destination, listener, null);
    }

    public static <REQUEST, REPLY> ISubscription reply(Class<? extends IMomTransport> transport, IBiDestination<REQUEST, REPLY> destination, IRequestListener<REQUEST, REPLY> listener, SubscribeInput input) {
        return ((IMomTransport)BEANS.get(transport)).reply(destination, listener, input != null ? input : MOM.newSubscribeInput());
    }

    public static IRegistrationHandle registerMarshaller(Class<? extends IMomTransport> transport, IDestination<?> destination, IMarshaller marshaller) {
        return ((IMomTransport)BEANS.get(transport)).registerMarshaller(destination, marshaller);
    }
}

