/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.security;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.rt.platform.util.EnumerationUtility;
import org.eclipse.scout.rt.security.AbstractPermissionCollection;
import org.eclipse.scout.rt.security.IPermission;
import org.eclipse.scout.rt.security.PermissionLevel;

public class DefaultPermissionCollection
extends AbstractPermissionCollection {
    private static final long serialVersionUID = 1L;
    private final Map<String, List<IPermission>> m_permissions = new HashMap<String, List<IPermission>>();
    private final List<Permission> m_javaPermissions = new ArrayList<Permission>();

    @Override
    public void add(Permission permission) {
        this.assertNotReadOnly();
        if (permission instanceof IPermission) {
            this.add((IPermission)((Object)permission));
        } else if (permission != null) {
            this.m_javaPermissions.add(permission);
        }
    }

    @Override
    public void add(IPermission permission) {
        this.assertNotReadOnly();
        if (permission != null) {
            this.m_permissions.computeIfAbsent(permission.getName(), k -> new ArrayList()).add(permission);
        }
    }

    @Override
    public void setReadOnly() {
        super.setReadOnly();
        this.assignPermissionCollectionInternal();
    }

    protected void assignPermissionCollectionInternal() {
        this.m_permissions.values().stream().flatMap(Collection::stream).forEach(p -> p.assignPermissionCollection(this));
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission == null) {
            return false;
        }
        if (permission instanceof IPermission) {
            return this.implies((IPermission)((Object)permission));
        }
        return this.m_javaPermissions.stream().anyMatch(def -> def.implies(permission));
    }

    @Override
    public boolean implies(IPermission permission) {
        if (permission == null) {
            return false;
        }
        return this.m_permissions.getOrDefault(permission.getName(), Collections.emptyList()).stream().anyMatch(def -> def.implies(permission));
    }

    @Override
    public PermissionLevel getGrantedPermissionLevel(IPermission permission) {
        if (permission == null) {
            return PermissionLevel.UNDEFINED;
        }
        Set grantedLevels = this.stream(permission).map(IPermission::getLevel).collect(Collectors.toSet());
        switch (grantedLevels.size()) {
            case 0: {
                return PermissionLevel.NONE;
            }
            case 1: {
                return (PermissionLevel)grantedLevels.iterator().next();
            }
        }
        return PermissionLevel.UNDEFINED;
    }

    @Override
    public Stream<IPermission> stream() {
        return this.m_permissions.values().stream().flatMap(Collection::stream);
    }

    @Override
    public Stream<IPermission> stream(IPermission permission) {
        if (permission == null) {
            return Stream.empty();
        }
        return this.m_permissions.getOrDefault(permission.getName(), Collections.emptyList()).stream().filter(def -> def.matches(permission));
    }

    @Override
    public Enumeration<Permission> elements() {
        return EnumerationUtility.asEnumeration(Stream.concat(this.stream().map(Permission.class::cast), this.m_javaPermissions.stream()).iterator());
    }
}

