/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons;

import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.config.ConfigPropertyProvider;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.security.SecurityUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.server.commons.ServerCommonsConfigProperties;
import org.eclipse.scout.rt.shared.services.common.file.IRemoteFileService;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class GlobalTrustManager {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalTrustManager.class);
    private static final String PATH_CERTS = "/certificates";

    public void installGlobalTrustManager() {
        this.installGlobalTrustManager("TLS", TrustManagerFactory.getDefaultAlgorithm());
    }

    public void installGlobalTrustManager(String protocol, String tmAlgorithm) {
        try {
            X509TrustManager globalTrustManager = this.createGlobalTrustManager(tmAlgorithm, this.getAllTrustedCertificates());
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(null, new TrustManager[]{globalTrustManager}, SecurityUtility.createSecureRandom());
            SSLContext.setDefault(sslContext);
        }
        catch (Exception e) {
            throw new ProcessingException("could not install global trust manager.", new Object[]{e});
        }
    }

    public X509TrustManager createTrustManager() {
        return this.createTrustManager(TrustManagerFactory.getDefaultAlgorithm());
    }

    public X509TrustManager createTrustManager(String tmAlgorithm) {
        try {
            return this.createGlobalTrustManager(tmAlgorithm, this.getAllTrustedCertificates());
        }
        catch (Exception e) {
            throw new ProcessingException("could not create trust manager.", new Object[]{e});
        }
    }

    protected List<X509Certificate> getAllTrustedCertificates() {
        ArrayList<X509Certificate> trustedCerts = new ArrayList<X509Certificate>();
        trustedCerts.addAll(this.getTrustedCertificatesInRemoteFiles());
        trustedCerts.addAll(this.getConfiguredTrustedCertificates());
        return trustedCerts;
    }

    protected List<X509Certificate> getConfiguredTrustedCertificates() {
        List certsNames = (List)CONFIG.getPropertyValue(ServerCommonsConfigProperties.TrustedCertificatesProperty.class);
        if (CollectionUtility.isEmpty((Collection)certsNames)) {
            return Collections.emptyList();
        }
        ArrayList<X509Certificate> trustedCerts = new ArrayList<X509Certificate>(certsNames.size());
        for (String certName : certsNames) {
            try {
                URL url = ConfigPropertyProvider.getResourceUrl((String)certName);
                if (url == null) {
                    LOG.warn("Configured trusted certificate '{}' could not be found.", (Object)certName);
                    continue;
                }
                LOG.info("Trusted certificate '{}' found.", (Object)certName);
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream in = url.openStream();){
                    trustedCerts.add(this.readX509Cert(in));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                LOG.info("Trusted certificate '{}' successfully installed.", (Object)certName);
            }
            catch (Exception e) {
                LOG.error("Failed to install trusted certificate '{}'.", (Object)certName, (Object)e);
            }
        }
        return trustedCerts;
    }

    protected List<X509Certificate> getTrustedCertificatesInRemoteFiles() {
        FilenameFilter certFilter = (file, name) -> name.toLowerCase().endsWith(".der");
        try {
            RemoteFile[] certRemoteFiles = ((IRemoteFileService)BEANS.get(IRemoteFileService.class)).getRemoteFiles(PATH_CERTS, certFilter, null);
            if (certRemoteFiles == null || certRemoteFiles.length < 1) {
                LOG.info("No certificates to trust in folder '{}' could be found.", (Object)PATH_CERTS);
                return Collections.emptyList();
            }
            return this.remoteFilesToCertificates(certRemoteFiles);
        }
        catch (RuntimeException e) {
            LOG.error("Could not access folder '{}' to import trusted certificates.", (Object)PATH_CERTS, (Object)e);
            return Collections.emptyList();
        }
    }

    protected List<X509Certificate> remoteFilesToCertificates(RemoteFile[] certRemoteFiles) {
        ArrayList<X509Certificate> trustedCerts = new ArrayList<X509Certificate>(certRemoteFiles.length);
        RemoteFile[] remoteFileArray = certRemoteFiles;
        int n = certRemoteFiles.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteFile rf = remoteFileArray[n2];
            try {
                LOG.info("Trusted certificate '{}' found.", (Object)rf.getName());
                Throwable throwable = null;
                Object var8_10 = null;
                try (InputStream in = rf.getDecompressedInputStream();){
                    trustedCerts.add(this.readX509Cert(in));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                LOG.info("Trusted certificate '{}' successfully installed.", (Object)rf.getName());
            }
            catch (Exception e) {
                LOG.info("Failed to install trusted certificate '{}'.", (Object)rf.getName(), (Object)e);
            }
            ++n2;
        }
        return trustedCerts;
    }

    protected X509TrustManager createGlobalTrustManager(String tmAlgorithm, List<X509Certificate> trustedCerts) throws NoSuchAlgorithmException, KeyStoreException {
        return new P_GlobalTrustManager(trustedCerts, tmAlgorithm);
    }

    protected X509Certificate readX509Cert(InputStream inputStream) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certFactory.generateCertificate(inputStream);
    }

    protected static class P_GlobalTrustManager
    implements X509TrustManager {
        private static final String CERTIFICATE_NOT_TRUSTED = "certificate not trusted.";
        private TrustManager[] m_installedTrustManagers;
        private final List<X509Certificate> m_trustedCerts;

        protected P_GlobalTrustManager(List<X509Certificate> trustedCerts, String tmAlgorithm) throws NoSuchAlgorithmException, KeyStoreException {
            this.m_trustedCerts = new ArrayList<X509Certificate>(trustedCerts);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(tmAlgorithm);
            trustManagerFactory.init((KeyStore)null);
            this.m_installedTrustManagers = trustManagerFactory.getTrustManagers();
            if (this.m_installedTrustManagers == null) {
                this.m_installedTrustManagers = new TrustManager[0];
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            TrustManager[] trustManagerArray = this.m_installedTrustManagers;
            int n = this.m_installedTrustManagers.length;
            int n2 = 0;
            while (n2 < n) {
                TrustManager installedTrustManager = trustManagerArray[n2];
                if (installedTrustManager instanceof X509TrustManager) {
                    try {
                        ((X509TrustManager)installedTrustManager).checkClientTrusted(certs, authType);
                    }
                    catch (CertificateException e) {
                        LOG.error(CERTIFICATE_NOT_TRUSTED, (Throwable)e);
                        throw e;
                    }
                }
                ++n2;
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            Object[] objectArray = certs;
            int n = certs.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate candidateCert = objectArray[n2];
                if (candidateCert != null) {
                    for (X509Certificate trustedCert : this.m_trustedCerts) {
                        if (trustedCert == null) continue;
                        try {
                            candidateCert.verify(trustedCert.getPublicKey());
                            candidateCert.checkValidity();
                            return;
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            // empty catch block
                        }
                    }
                }
                ++n2;
            }
            objectArray = this.m_installedTrustManagers;
            n = this.m_installedTrustManagers.length;
            n2 = 0;
            while (n2 < n) {
                Object trustManager = objectArray[n2];
                if (trustManager instanceof X509TrustManager) {
                    try {
                        ((X509TrustManager)trustManager).checkServerTrusted(certs, authType);
                    }
                    catch (CertificateException e) {
                        LOG.error(CERTIFICATE_NOT_TRUSTED, (Throwable)e);
                        throw e;
                    }
                }
                ++n2;
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            ArrayList<X509Certificate> trustedCertsAll = new ArrayList<X509Certificate>(this.m_trustedCerts);
            TrustManager[] trustManagerArray = this.m_installedTrustManagers;
            int n = this.m_installedTrustManagers.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate[] certs;
                TrustManager trustManager = trustManagerArray[n2];
                if (trustManager instanceof X509TrustManager && (certs = ((X509TrustManager)trustManager).getAcceptedIssuers()) != null && certs.length > 0) {
                    trustedCertsAll.addAll(Arrays.asList(certs));
                }
                ++n2;
            }
            return trustedCertsAll.toArray(new X509Certificate[0]);
        }
    }
}

