/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.authentication;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.AbstractBooleanConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractLongConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractStringConfigProperty;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.security.SecurityUtility;
import org.eclipse.scout.rt.platform.security.SimplePrincipal;
import org.eclipse.scout.rt.platform.util.Base64Utility;
import org.eclipse.scout.rt.server.commons.authentication.IAccessController;
import org.eclipse.scout.rt.server.commons.authentication.ServletFilterHelper;
import org.eclipse.scout.rt.shared.SharedConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieAccessController
implements IAccessController {
    private static final Logger LOG = LoggerFactory.getLogger(CookieAccessController.class);
    private static final String SESSION_ATTRIBUTE_COOKIE_SENT = String.valueOf(CookieAccessController.class.getName()) + "#cookieSent";
    private boolean m_enabled;
    private String m_cookieName;
    private long m_maxAge;
    private byte[] m_signKey;

    @PostConstruct
    protected void init() {
        this.m_enabled = (Boolean)CONFIG.getPropertyValue(EnabledProperty.class);
        this.m_cookieName = (String)CONFIG.getPropertyValue(NameProperty.class);
        this.m_maxAge = (Long)CONFIG.getPropertyValue(MaxAgeProperty.class);
        this.m_signKey = (byte[])CONFIG.getPropertyValue(SharedConfigProperties.AuthTokenPrivateKeyProperty.class);
        if (this.m_signKey == null) {
            throw new PlatformException("Missing config.properties entry used for signing auth data: '{}'", new Object[]{((SharedConfigProperties.AuthTokenPrivateKeyProperty)BEANS.get(SharedConfigProperties.AuthTokenPrivateKeyProperty.class)).getKey()});
        }
    }

    @Override
    public boolean handle(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (!this.m_enabled) {
            return false;
        }
        switch (this.getTarget(req)) {
            case "/login": 
            case "/logout": {
                this.clearPrincipalOnCookie(resp);
                return false;
            }
        }
        ServletFilterHelper helper = (ServletFilterHelper)BEANS.get(ServletFilterHelper.class);
        Principal p = helper.getPrincipalOnSession(req);
        if (p == null && (p = this.loadPrincipalFromCookie(req)) != null) {
            helper.putPrincipalOnSession(req, p);
            return false;
        }
        if (p != null) {
            this.storePrincipalToCookie(req, resp, p);
            return false;
        }
        return false;
    }

    @Override
    public void destroy() {
    }

    protected String getTarget(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            return pathInfo;
        }
        String requestURI = request.getRequestURI();
        return requestURI.substring(requestURI.lastIndexOf(47));
    }

    protected String signValue(String value) {
        try {
            byte[] sig = SecurityUtility.createMac((byte[])this.m_signKey, (byte[])value.getBytes(StandardCharsets.UTF_8));
            return String.valueOf(Base64Utility.encode((byte[])sig)) + ":" + value;
        }
        catch (Exception e) {
            throw new PlatformException("Failed signing value '{}'", new Object[]{value, e});
        }
    }

    protected String verifyValue(String signedValue) {
        String value;
        if (signedValue != null && signedValue.indexOf(58) > -1 && this.signValue(value = signedValue.substring(signedValue.indexOf(58) + 1)).equals(signedValue)) {
            return value;
        }
        return null;
    }

    protected Principal loadPrincipalFromCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                String userId;
                Cookie c = cookieArray[n2];
                if (this.m_cookieName.equals(c.getName()) && (userId = this.verifyValue(c.getValue())) != null) {
                    LOG.info("Load signed cookie '{}' for '{}'", (Object)this.m_cookieName, (Object)userId);
                    HttpSession session = request.getSession(false);
                    if (session != null) {
                        session.setAttribute(SESSION_ATTRIBUTE_COOKIE_SENT, (Object)Boolean.TRUE);
                    }
                    return new SimplePrincipal(userId);
                }
                ++n2;
            }
        }
        return null;
    }

    protected void storePrincipalToCookie(HttpServletRequest req, HttpServletResponse resp, Principal p) {
        HttpSession session = req.getSession(false);
        if (session == null) {
            return;
        }
        if (Boolean.TRUE.equals(session.getAttribute(SESSION_ATTRIBUTE_COOKIE_SENT))) {
            return;
        }
        session.setAttribute(SESSION_ATTRIBUTE_COOKIE_SENT, (Object)Boolean.TRUE);
        String signedValue = this.signValue(p.getName());
        LOG.info("Store signed cookie '{}' for '{}'", (Object)this.m_cookieName, (Object)p.getName());
        Cookie myCookie = new Cookie(this.m_cookieName, signedValue);
        myCookie.setMaxAge((int)this.m_maxAge);
        resp.addCookie(myCookie);
    }

    protected void clearPrincipalOnCookie(HttpServletResponse resp) {
        LOG.info("Remove cookie '{}'", (Object)this.m_cookieName);
        Cookie myCookie = new Cookie(this.m_cookieName, "");
        myCookie.setMaxAge(0);
        resp.addCookie(myCookie);
    }

    public static class EnabledProperty
    extends AbstractBooleanConfigProperty {
        public String getKey() {
            return "scout.auth.cookieEnabled";
        }

        public String description() {
            return String.format("Specifies if the '%s' is enabled.", CookieAccessController.class.getSimpleName());
        }

        public Boolean getDefaultValue() {
            return false;
        }
    }

    public static class MaxAgeProperty
    extends AbstractLongConfigProperty {
        public String getKey() {
            return "scout.auth.cookieMaxAge";
        }

        public String description() {
            return String.format("If the '%s' is enabled, specifies the maximum age in seconds for the cookie.\nA positive value indicates that the cookie will expire after that many seconds have passed.\nA negative value means that the cookie is not stored persistently and will be deleted when the Web browser exits. A zero value causes the cookie to be deleted.\nThe default value is 10 hours.", CookieAccessController.class.getSimpleName());
        }

        public Long getDefaultValue() {
            return 36000L;
        }
    }

    public static class NameProperty
    extends AbstractStringConfigProperty {
        public String getKey() {
            return "scout.auth.cookieName";
        }

        public String description() {
            return String.format("If the '%s' is enabled, specifies the name for the cookie.\nThe name must conform to RFC 2109. However, vendors may provide a configuration option that allows cookie names conforming to the original Netscape Cookie Specification to be accepted.\nBy default 'sso.user.id' is used as cookie name.", CookieAccessController.class.getSimpleName());
        }

        public String getDefaultValue() {
            return "sso.user.id";
        }
    }
}

