/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.authentication;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.security.IPrincipalProducer;
import org.eclipse.scout.rt.platform.security.IPrincipalVerifier;
import org.eclipse.scout.rt.platform.security.SimplePrincipalProducer;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.authentication.IAccessController;
import org.eclipse.scout.rt.server.commons.authentication.PathInfoFilter;
import org.eclipse.scout.rt.server.commons.authentication.ServletFilterHelper;

public class TrivialAccessController
implements IAccessController {
    private TrivialAuthConfig m_config;

    public TrivialAccessController init(TrivialAuthConfig config) {
        this.m_config = config;
        return this;
    }

    @Override
    public boolean handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.m_config.isEnabled()) {
            return false;
        }
        switch (this.getTarget(request)) {
            case "/login": {
                if (this.m_config.isHandleAuthentication()) {
                    this.handleLoginRequest(request, response);
                    return true;
                }
                return false;
            }
            case "/logout": {
                if (this.m_config.isHandleAuthentication()) {
                    this.handleLogoutRequest(request, response);
                    return true;
                }
                return false;
            }
            case "/auth": {
                return false;
            }
        }
        return this.handleRequest(request, response, chain);
    }

    @Override
    public void destroy() {
    }

    protected boolean handleRequest(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletFilterHelper helper = (ServletFilterHelper)BEANS.get(ServletFilterHelper.class);
        if (helper.redirectIncompleteBasePath(request, response, false)) {
            return true;
        }
        if (helper.isRunningWithValidSubject(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        Principal principal = helper.findPrincipal(request, this.m_config.getPrincipalProducer());
        if (principal != null) {
            if (this.m_config.getPrincipalVerifier() != null && !this.m_config.getPrincipalVerifier().verify(principal)) {
                return false;
            }
            helper.continueChainAsSubject(principal, request, response, chain);
            return true;
        }
        if (this.m_config.getPathInfoFilter().accepts(String.valueOf(StringUtility.emptyIfNull((Object)request.getServletPath())) + StringUtility.emptyIfNull((Object)request.getPathInfo()))) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    protected void handleLoginRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.m_config.isLoginPageInstalled()) {
            ((ServletFilterHelper)BEANS.get(ServletFilterHelper.class)).forwardToLoginForm(request, response);
        }
    }

    protected void handleLogoutRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ((ServletFilterHelper)BEANS.get(ServletFilterHelper.class)).doLogout(request);
        if (this.m_config.isLoginPageInstalled()) {
            ((ServletFilterHelper)BEANS.get(ServletFilterHelper.class)).forwardToLogoutForm(request, response);
        }
    }

    protected String getTarget(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            return pathInfo;
        }
        String requestURI = request.getRequestURI();
        return requestURI.substring(requestURI.lastIndexOf(47));
    }

    public static class TrivialAuthConfig {
        private boolean m_enabled = true;
        private IPrincipalProducer m_principalProducer = (IPrincipalProducer)BEANS.get(SimplePrincipalProducer.class);
        private PathInfoFilter m_exclusionFilter;
        private boolean m_handleAuthentication = true;
        private boolean m_loginPageInstalled = false;
        private IPrincipalVerifier m_principalVerifier;

        public boolean isEnabled() {
            return this.m_enabled;
        }

        public TrivialAuthConfig withEnabled(boolean enabled) {
            this.m_enabled = enabled;
            return this;
        }

        public IPrincipalProducer getPrincipalProducer() {
            return this.m_principalProducer;
        }

        public TrivialAuthConfig withPrincipalProducer(IPrincipalProducer principalProducer) {
            this.m_principalProducer = principalProducer;
            return this;
        }

        public IPrincipalVerifier getPrincipalVerifier() {
            return this.m_principalVerifier;
        }

        public TrivialAuthConfig withPrincipalVerifier(IPrincipalVerifier principalVerifier) {
            this.m_principalVerifier = principalVerifier;
            return this;
        }

        public PathInfoFilter getPathInfoFilter() {
            return this.m_exclusionFilter;
        }

        public TrivialAuthConfig withExclusionFilter(String exclusionFilter) {
            this.m_exclusionFilter = new PathInfoFilter(exclusionFilter);
            return this;
        }

        public boolean isHandleAuthentication() {
            return this.m_handleAuthentication;
        }

        public TrivialAuthConfig withHandleAuthentication(boolean handleAuthentication) {
            this.m_handleAuthentication = handleAuthentication;
            return this;
        }

        public boolean isLoginPageInstalled() {
            return this.m_loginPageInstalled;
        }

        public TrivialAuthConfig withLoginPageInstalled(boolean loginPageInstalled) {
            this.m_loginPageInstalled = loginPageInstalled;
            return this;
        }
    }
}

