/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.healthcheck;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.util.BooleanUtility;
import org.eclipse.scout.rt.server.commons.healthcheck.IHealthChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHealthChecker
implements IHealthChecker {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHealthChecker.class);
    private final AtomicBoolean m_lastStatus = new AtomicBoolean(false);
    private final AtomicLong m_timestamp = new AtomicLong(0L);
    protected final String m_name;
    protected final long m_timeToLive;
    protected final long m_timeout;
    private IFuture<Boolean> m_future;
    private long m_futureStart;
    private final ReentrantLock m_lock = new ReentrantLock();

    public AbstractHealthChecker() {
        this.m_name = this.getConfiguredName();
        this.m_timeToLive = this.getConfiguredTimeToLiveMillis();
        this.m_timeout = this.getConfiguredTimeoutMillis();
    }

    protected String getConfiguredName() {
        return this.getClass().getSimpleName();
    }

    protected long getConfiguredTimeToLiveMillis() {
        return TimeUnit.SECONDS.toMillis(1L);
    }

    protected long getConfiguredTimeoutMillis() {
        return 0L;
    }

    protected abstract boolean execCheckHealth() throws Exception;

    @Override
    public String getName() {
        return this.m_name;
    }

    public boolean getLastStatus() {
        return this.m_lastStatus.get();
    }

    public boolean isExpired() {
        return this.m_timeToLive <= 0L || this.m_timestamp.get() + this.m_timeToLive < System.currentTimeMillis();
    }

    protected IFuture getFuture() throws InterruptedException {
        this.m_lock.lockInterruptibly();
        try {
            IFuture<Boolean> iFuture = this.m_future;
            return iFuture;
        }
        finally {
            this.m_lock.unlock();
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean checkHealth(RunContext context) {
        if (!this.isExpired()) {
            return this.m_lastStatus.get();
        }
        if (!this.m_lock.tryLock()) {
            return this.m_lastStatus.get();
        }
        try {
            if (this.m_future != null) {
                if (this.m_future.isFinished()) {
                    Boolean result = null;
                    try {
                        result = (Boolean)this.m_future.awaitDoneAndGet();
                        LOG.debug("HealthCheck[{}] is finished and result is stored, status={}, future={}", new Object[]{this.getName(), result, this.m_future});
                    }
                    catch (Throwable t) {
                        result = false;
                        LOG.warn("HealthCheck[{}] failed, future={}.", new Object[]{this.getName(), this.m_future, t});
                    }
                    this.m_lastStatus.set(BooleanUtility.nvl((Boolean)result));
                    this.m_timestamp.set(System.currentTimeMillis());
                    this.m_future = null;
                } else if (this.m_timeout > 0L && this.m_futureStart + this.m_timeout < System.currentTimeMillis()) {
                    LOG.warn("HealthCheck[{}] has timed out after {}ms, future={}. Cancelling job now.", new Object[]{this.getName(), this.m_timeout, this.m_future});
                    this.m_future.cancel(true);
                    this.m_future = null;
                    this.m_lastStatus.set(false);
                    this.m_timestamp.set(System.currentTimeMillis());
                }
            }
            if (this.m_future == null && this.isExpired()) {
                this.m_futureStart = System.currentTimeMillis();
                this.m_future = Jobs.schedule(() -> {
                    LOG.debug("HealthCheck[{}] has started", (Object)this.getName());
                    try {
                        boolean result = this.execCheckHealth();
                        if (result) {
                            LOG.debug("HealthCheck[{}] was successful", (Object)this.getName());
                        } else {
                            LOG.warn("HealthCheck[{}] failed.", (Object)this.getName());
                        }
                        return result;
                    }
                    catch (InterruptedException e) {
                        LOG.debug("HealthCheck[{}] was interrupted", (Object)this.getName(), (Object)e);
                        return false;
                    }
                }, (JobInput)Jobs.newInput().withRunContext(context).withName(this.getName(), new Object[0]));
                LOG.debug("HealthCheck[{}] was started with a new scheduled job, future={}", (Object)this.getName(), this.m_future);
            }
            boolean bl = this.m_lastStatus.get();
            return bl;
        }
        finally {
            this.m_lock.unlock();
        }
    }
}

