/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.ServerCommonsConfigProperties;

@Bean
public class ContentSecurityPolicy {
    public static final String DIRECTIVE_SEPARATOR = "; ";
    public static final String SOURCE_SEPARATOR = " ";
    public static final String DIRECTIVE_BASE_URI = "base-uri";
    public static final String DIRECTIVE_IMG_SRC = "img-src";
    public static final String DIRECTIVE_STYLE_SRC = "style-src";
    public static final String DIRECTIVE_CHILD_SRC = "child-src";
    public static final String DIRECTIVE_CONNECT_SRC = "connect-src";
    public static final String DIRECTIVE_DEFAULT_SRC = "default-src";
    public static final String DIRECTIVE_FONT_SRC = "font-src";
    public static final String DIRECTIVE_FORM_ACTION = "form-action";
    public static final String DIRECTIVE_FRAME_ANCESTORS = "frame-ancestors";
    public static final String DIRECTIVE_MEDIA_SRC = "media-src";
    public static final String DIRECTIVE_OBJECT_SRC = "object-src";
    public static final String DIRECTIVE_PLUGIN_TYPES = "plugin-types";
    public static final String DIRECTIVE_REPORT_URI = "report-uri";
    public static final String DIRECTIVE_SANDBOX = "sandbox";
    public static final String DIRECTIVE_SCRIPT_SRC = "script-src";
    private final Map<String, String> m_directives = new LinkedHashMap<String, String>();

    public ContentSecurityPolicy() {
        this.initDirectives();
    }

    protected void initDirectives() {
        this.withBaseUri(this.getConfiguredDefault(DIRECTIVE_BASE_URI, null));
        this.withImgSrc(this.getConfiguredDefault(DIRECTIVE_IMG_SRC, "'self'"));
        this.withStyleSrc(this.getConfiguredDefault(DIRECTIVE_STYLE_SRC, "'self' 'unsafe-inline'"));
        this.withChildSrc(this.getConfiguredDefault(DIRECTIVE_CHILD_SRC, "*"));
        this.withConnectSrc(this.getConfiguredDefault(DIRECTIVE_CONNECT_SRC, null));
        this.withDefaultSrc(this.getConfiguredDefault(DIRECTIVE_DEFAULT_SRC, "'self'"));
        this.withFontSrc(this.getConfiguredDefault(DIRECTIVE_FONT_SRC, null));
        this.withFormAction(this.getConfiguredDefault(DIRECTIVE_FORM_ACTION, null));
        this.withFrameAncestors(this.getConfiguredDefault(DIRECTIVE_FRAME_ANCESTORS, null));
        this.withMediaSrc(this.getConfiguredDefault(DIRECTIVE_MEDIA_SRC, null));
        this.withObjectSrc(this.getConfiguredDefault(DIRECTIVE_OBJECT_SRC, null));
        this.withPluginTypes(this.getConfiguredDefault(DIRECTIVE_PLUGIN_TYPES, null));
        this.withReportUri(this.getConfiguredDefault(DIRECTIVE_REPORT_URI, "csp-report"));
        this.withSandbox(this.getConfiguredDefault(DIRECTIVE_SANDBOX, null));
        this.withScriptSrc(this.getConfiguredDefault(DIRECTIVE_SCRIPT_SRC, "'self'"));
    }

    protected String getConfiguredDefault(String directiveKey, String fallbackValue) {
        Map mapProperty = (Map)CONFIG.getPropertyValue(ServerCommonsConfigProperties.CspDirectiveProperty.class);
        if (mapProperty == null) {
            return fallbackValue;
        }
        String configValue = (String)mapProperty.get(directiveKey);
        if (configValue == null) {
            return fallbackValue;
        }
        return configValue;
    }

    protected void putOrRemove(String key, String value) {
        if (value == null) {
            this.m_directives.remove(key);
        } else {
            this.m_directives.put(key, value);
        }
    }

    public final Map<String, String> getDirectives() {
        return this.m_directives;
    }

    public void empty() {
        this.m_directives.clear();
    }

    public ContentSecurityPolicy withBaseUri(String baseUri) {
        this.putOrRemove(DIRECTIVE_BASE_URI, baseUri);
        return this;
    }

    public ContentSecurityPolicy appendBaseUri(String baseUri) {
        return this.addOrAppend(DIRECTIVE_BASE_URI, baseUri);
    }

    public ContentSecurityPolicy withChildSrc(String childSrc) {
        this.putOrRemove(DIRECTIVE_CHILD_SRC, childSrc);
        return this;
    }

    public ContentSecurityPolicy appendChildSrc(String childSrc) {
        return this.addOrAppend(DIRECTIVE_CHILD_SRC, childSrc);
    }

    public ContentSecurityPolicy withConnectSrc(String connectSrc) {
        this.putOrRemove(DIRECTIVE_CONNECT_SRC, connectSrc);
        return this;
    }

    public ContentSecurityPolicy appendConnectSrc(String connectSrc) {
        return this.addOrAppend(DIRECTIVE_CONNECT_SRC, connectSrc);
    }

    public ContentSecurityPolicy withDefaultSrc(String defaultSrc) {
        this.putOrRemove(DIRECTIVE_DEFAULT_SRC, defaultSrc);
        return this;
    }

    public ContentSecurityPolicy appendDefaultSrc(String defaultSrc) {
        return this.addOrAppend(DIRECTIVE_DEFAULT_SRC, defaultSrc);
    }

    public ContentSecurityPolicy withFontSrc(String fontSrc) {
        this.putOrRemove(DIRECTIVE_FONT_SRC, fontSrc);
        return this;
    }

    public ContentSecurityPolicy appendFontSrc(String fontSrc) {
        return this.addOrAppend(DIRECTIVE_FONT_SRC, fontSrc);
    }

    public ContentSecurityPolicy withFormAction(String formAction) {
        this.putOrRemove(DIRECTIVE_FORM_ACTION, formAction);
        return this;
    }

    public ContentSecurityPolicy appendFormAction(String formAction) {
        return this.addOrAppend(DIRECTIVE_FORM_ACTION, formAction);
    }

    public ContentSecurityPolicy withFrameAncestors(String frameAncestors) {
        this.putOrRemove(DIRECTIVE_FRAME_ANCESTORS, frameAncestors);
        return this;
    }

    public ContentSecurityPolicy appendFrameAncestors(String frameAncestors) {
        return this.addOrAppend(DIRECTIVE_FRAME_ANCESTORS, frameAncestors);
    }

    public ContentSecurityPolicy withImgSrc(String imgSrc) {
        this.putOrRemove(DIRECTIVE_IMG_SRC, imgSrc);
        return this;
    }

    public ContentSecurityPolicy appendImgSrc(String imgSrc) {
        return this.addOrAppend(DIRECTIVE_IMG_SRC, imgSrc);
    }

    public ContentSecurityPolicy withMediaSrc(String mediaSrc) {
        this.putOrRemove(DIRECTIVE_MEDIA_SRC, mediaSrc);
        return this;
    }

    public ContentSecurityPolicy appendMediaSrc(String mediaSrc) {
        return this.addOrAppend(DIRECTIVE_MEDIA_SRC, mediaSrc);
    }

    public ContentSecurityPolicy withObjectSrc(String objectSrc) {
        this.putOrRemove(DIRECTIVE_OBJECT_SRC, objectSrc);
        return this;
    }

    public ContentSecurityPolicy appendObjectSrc(String objectSrc) {
        return this.addOrAppend(DIRECTIVE_OBJECT_SRC, objectSrc);
    }

    public ContentSecurityPolicy withPluginTypes(String pluginTypes) {
        this.putOrRemove(DIRECTIVE_PLUGIN_TYPES, pluginTypes);
        return this;
    }

    public ContentSecurityPolicy appendPluginTypes(String pluginTypes) {
        return this.addOrAppend(DIRECTIVE_PLUGIN_TYPES, pluginTypes);
    }

    public ContentSecurityPolicy withReportUri(String reportUri) {
        this.putOrRemove(DIRECTIVE_REPORT_URI, reportUri);
        return this;
    }

    public ContentSecurityPolicy appendReportUri(String reportUri) {
        return this.addOrAppend(DIRECTIVE_REPORT_URI, reportUri);
    }

    public ContentSecurityPolicy withSandbox(String sandbox) {
        this.putOrRemove(DIRECTIVE_SANDBOX, sandbox);
        return this;
    }

    public ContentSecurityPolicy appendSandbox(String sandbox) {
        return this.addOrAppend(DIRECTIVE_SANDBOX, sandbox);
    }

    public ContentSecurityPolicy withScriptSrc(String scriptSrc) {
        this.putOrRemove(DIRECTIVE_SCRIPT_SRC, scriptSrc);
        return this;
    }

    public ContentSecurityPolicy appendScriptSrc(String scriptSrc) {
        return this.addOrAppend(DIRECTIVE_SCRIPT_SRC, scriptSrc);
    }

    public ContentSecurityPolicy withStyleSrc(String styleSrc) {
        this.putOrRemove(DIRECTIVE_STYLE_SRC, styleSrc);
        return this;
    }

    public ContentSecurityPolicy appendStyleSrc(String styleSrc) {
        return this.addOrAppend(DIRECTIVE_STYLE_SRC, styleSrc);
    }

    protected ContentSecurityPolicy addOrAppend(String key, String value) {
        if (value == null) {
            return this;
        }
        if (this.m_directives.containsKey(key)) {
            String existingSource = this.m_directives.get(key);
            if (!StringUtility.containsString((String)existingSource, (String)value)) {
                this.m_directives.put(key, StringUtility.join((String)SOURCE_SEPARATOR, (Object[])new Object[]{existingSource, value}));
            }
        } else {
            this.m_directives.put(key, value);
        }
        return this;
    }

    public String toToken() {
        ArrayList<String> cspDirectives = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.m_directives.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            cspDirectives.add(StringUtility.join((String)SOURCE_SEPARATOR, (Object[])new Object[]{entry.getKey(), entry.getValue()}));
        }
        return StringUtility.join((String)DIRECTIVE_SEPARATOR, cspDirectives);
    }

    public String toString() {
        return this.toToken();
    }
}

