/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.FinalValue;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.ui.IUiDeviceType;
import org.eclipse.scout.rt.shared.ui.IUiEngineType;
import org.eclipse.scout.rt.shared.ui.IUiLayer;
import org.eclipse.scout.rt.shared.ui.IUiSystem;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiEngineType;
import org.eclipse.scout.rt.shared.ui.UiLayer;
import org.eclipse.scout.rt.shared.ui.UiSystem;
import org.eclipse.scout.rt.shared.ui.UserAgents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class HttpClientInfo {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientInfo.class);
    protected static final String HTTP_CLIENT_INFO_ATTRIBUTE_NAME = HttpClientInfo.class.getName();
    private final FinalValue<String> m_userAgent = new FinalValue();
    private UiEngineType m_engineType = UiEngineType.UNKNOWN;
    private Version m_engineVersion;
    private boolean m_isWebkit = false;
    private boolean m_isGecko = false;
    private boolean m_isMshtml = false;
    private boolean m_isOpera = false;
    private UiSystem m_system = UiSystem.UNKNOWN;
    private Version m_systemVersion;
    private boolean m_isMobile = false;
    private boolean m_isTablet = false;
    private boolean m_isStandalone = false;

    public HttpClientInfo init(String userAgent) {
        this.m_userAgent.set((Object)StringUtility.emptyIfNull((Object)userAgent));
        this.initInfos();
        return this;
    }

    protected void initInfos() {
        this.initHttpClientInfo();
        this.initSystemInfo();
    }

    protected void initHttpClientInfo() {
        boolean isGecko;
        String regex;
        String userAgent = this.getUserAgent();
        boolean isOpera = StringUtility.containsRegEx((String)userAgent, (String)(regex = "Opera[\\s\\/]([0-9\\.]*)"));
        if (isOpera) {
            this.setOpera(true);
            this.setEngineType(UiEngineType.OPERA);
            this.setEngineVersion(HttpClientInfo.extractVersion(userAgent, regex));
            return;
        }
        regex = "KHTML\\/([0-9-\\.]*)";
        boolean isKonqueror = StringUtility.containsRegEx((String)userAgent, (String)regex);
        if (isKonqueror) {
            this.setWebkit(true);
            this.setEngineType(UiEngineType.KONQUEROR);
            this.setEngineVersion(HttpClientInfo.extractVersion(userAgent, regex));
            return;
        }
        regex = "Edge\\/([^ ]+)$";
        boolean isEdge = StringUtility.containsRegEx((String)userAgent, (String)regex);
        if (isEdge) {
            this.setEngineType(UiEngineType.EDGE);
            this.setEngineVersion(HttpClientInfo.parseEdgeVersion(userAgent));
            return;
        }
        regex = "AppleWebKit\\/([^ ]+)";
        boolean isWebkit = StringUtility.containsRegEx((String)userAgent, (String)regex);
        if (isWebkit) {
            this.setWebkit(true);
            if (userAgent.contains("Chrome")) {
                this.setEngineType(UiEngineType.CHROME);
            } else if (userAgent.contains("Safari")) {
                if (userAgent.contains("Android")) {
                    this.setEngineType(UiEngineType.ANDROID);
                } else {
                    this.setEngineType(UiEngineType.SAFARI);
                }
            } else if (userAgent.contains("Mobile")) {
                this.setEngineType(UiEngineType.SAFARI);
                this.setStandalone(true);
            }
            this.setEngineVersion(HttpClientInfo.extractVersion(userAgent, regex));
            return;
        }
        regex = "(?:MSIE\\s+|Trident/)([^\\);]+)(\\)|;)";
        boolean isMshtml = StringUtility.containsRegEx((String)userAgent, (String)regex);
        if (isMshtml) {
            this.setMshtml(true);
            this.setEngineType(UiEngineType.IE);
            this.setEngineVersion(HttpClientInfo.extractVersion(userAgent, regex));
            return;
        }
        regex = "rv\\:([^\\);]+)(\\)|;)";
        boolean bl = isGecko = userAgent.contains("Gecko") && StringUtility.containsRegEx((String)userAgent, (String)regex);
        if (isGecko) {
            this.setGecko(true);
            if (userAgent.contains("Firefox")) {
                this.setEngineType(UiEngineType.FIREFOX);
            }
            this.setEngineVersion(HttpClientInfo.extractVersion(userAgent, regex));
            return;
        }
    }

    protected void initSystemInfo() {
        String userAgent = this.getUserAgent();
        if (userAgent.contains("Windows") || userAgent.contains("Win32") || userAgent.contains("Win64") || userAgent.contains("Win95")) {
            this.setSystem(UiSystem.WINDOWS);
            if (userAgent.contains("Windows Phone") || userAgent.contains("IEMobile")) {
                this.setSystemVersion(HttpClientInfo.parseWindowsPhoneVersion(userAgent));
                this.setMobile(true);
            } else {
                this.setSystemVersion(HttpClientInfo.parseWindowsVersion(userAgent));
            }
        } else if (userAgent.contains("Macintosh") || userAgent.contains("MacPPC") || userAgent.contains("MacIntel") || userAgent.contains("Mac_PowerPC")) {
            this.setSystem(UiSystem.OSX);
        } else if (userAgent.contains("Android")) {
            this.setSystem(UiSystem.ANDROID);
            this.setSystemVersion(HttpClientInfo.parseAndroidVersion(userAgent));
            if (this.getSystemVersion() == null || this.getSystemVersion().getMajor() <= 2) {
                this.setMobile(true);
            } else if (this.getSystemVersion().getMajor() == 3) {
                this.setTablet(true);
            } else if (this.getUserAgent().contains("Mobile")) {
                this.setMobile(true);
            } else {
                this.setTablet(true);
            }
        } else if (userAgent.contains("X11") || userAgent.contains("Linux") || userAgent.contains("BSD") || userAgent.contains("SunOS") || userAgent.contains("DragonFly")) {
            this.setSystem(UiSystem.UNIX);
        } else if (userAgent.contains("iPad")) {
            this.setSystem(UiSystem.IOS);
            this.setSystemVersion(HttpClientInfo.parseIosVersion(userAgent));
            this.setTablet(true);
        } else if (userAgent.contains("iPhone") || userAgent.contains("iPod")) {
            this.setSystem(UiSystem.IOS);
            this.setSystemVersion(HttpClientInfo.parseIosVersion(userAgent));
            this.setMobile(true);
        }
    }

    public String getUserAgent() {
        Assertions.assertTrue((boolean)this.m_userAgent.isSet());
        return (String)this.m_userAgent.get();
    }

    public boolean isWebkit() {
        return this.m_isWebkit;
    }

    protected void setWebkit(boolean isWebkit) {
        this.m_isWebkit = isWebkit;
    }

    public boolean isGecko() {
        return this.m_isGecko;
    }

    protected void setGecko(boolean isGecko) {
        this.m_isGecko = isGecko;
    }

    public boolean isMshtml() {
        return this.m_isMshtml;
    }

    protected void setMshtml(boolean isMshtml) {
        this.m_isMshtml = isMshtml;
    }

    public boolean isOpera() {
        return this.m_isOpera;
    }

    protected void setOpera(boolean isOpera) {
        this.m_isOpera = isOpera;
    }

    public boolean isMobile() {
        return this.m_isMobile;
    }

    protected void setMobile(boolean isMobile) {
        this.m_isMobile = isMobile;
    }

    public boolean isTablet() {
        return this.m_isTablet;
    }

    protected void setTablet(boolean isTablet) {
        this.m_isTablet = isTablet;
    }

    public boolean isStandalone() {
        return this.m_isStandalone;
    }

    protected void setStandalone(boolean isStandalone) {
        this.m_isStandalone = isStandalone;
    }

    public UiEngineType getEngineType() {
        return this.m_engineType;
    }

    protected void setEngineType(UiEngineType engineType) {
        this.m_engineType = engineType;
    }

    public UiSystem getSystem() {
        return this.m_system;
    }

    protected void setSystem(UiSystem system) {
        this.m_system = system;
    }

    public Version getEngineVersion() {
        return this.m_engineVersion;
    }

    protected void setEngineVersion(Version engineVersion) {
        this.m_engineVersion = engineVersion;
    }

    public Version getSystemVersion() {
        return this.m_systemVersion;
    }

    protected void setSystemVersion(Version systemVersion) {
        this.m_systemVersion = systemVersion;
    }

    public boolean isDesktop() {
        return !this.isTablet() && !this.isMobile();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_isGecko ? 1231 : 1237);
        result = 31 * result + (this.m_isMobile ? 1231 : 1237);
        result = 31 * result + (this.m_isMshtml ? 1231 : 1237);
        result = 31 * result + (this.m_isOpera ? 1231 : 1237);
        result = 31 * result + (this.m_isStandalone ? 1231 : 1237);
        result = 31 * result + (this.m_isTablet ? 1231 : 1237);
        result = 31 * result + (this.m_isWebkit ? 1231 : 1237);
        result = 31 * result + (this.m_system == null ? 0 : this.m_system.hashCode());
        result = 31 * result + (this.m_systemVersion == null ? 0 : this.m_systemVersion.hashCode());
        result = 31 * result + (this.m_engineType == null ? 0 : this.m_engineType.hashCode());
        result = 31 * result + (this.m_userAgent == null ? 0 : this.m_userAgent.hashCode());
        result = 31 * result + (this.m_engineVersion == null ? 0 : this.m_engineVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpClientInfo other = (HttpClientInfo)obj;
        if (this.m_isGecko != other.m_isGecko) {
            return false;
        }
        if (this.m_isMobile != other.m_isMobile) {
            return false;
        }
        if (this.m_isMshtml != other.m_isMshtml) {
            return false;
        }
        if (this.m_isOpera != other.m_isOpera) {
            return false;
        }
        if (this.m_isStandalone != other.m_isStandalone) {
            return false;
        }
        if (this.m_isTablet != other.m_isTablet) {
            return false;
        }
        if (this.m_isWebkit != other.m_isWebkit) {
            return false;
        }
        if (this.m_system != other.m_system) {
            return false;
        }
        if (this.m_systemVersion == null ? other.m_systemVersion != null : !this.m_systemVersion.equals(other.m_systemVersion)) {
            return false;
        }
        if (this.m_engineType != other.m_engineType) {
            return false;
        }
        if (ObjectUtility.notEquals((Object)((String)this.m_userAgent.get()), (Object)((String)other.m_userAgent.get()))) {
            return false;
        }
        return !(this.m_engineVersion == null ? other.m_engineVersion != null : !this.m_engineVersion.equals(other.m_engineVersion));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("System: ").append(this.getSystem());
        sb.append(" / SystemVersion: ").append(this.getSystemVersion());
        if (this.isWebkit()) {
            sb.append(" / isWebkit");
        } else if (this.isGecko()) {
            sb.append(" / isGecko");
        } else if (this.isMshtml()) {
            sb.append(" / isMshtml");
        }
        if (this.isTablet()) {
            sb.append(" / isTablet");
        } else if (this.isMobile()) {
            sb.append(" / isMobile");
        }
        sb.append(" / EngineType: ").append(this.getEngineType());
        sb.append(" / EngineVersion: ").append(this.getEngineVersion());
        sb.append(" / UserAgent: ").append((String)this.m_userAgent.get());
        return sb.toString();
    }

    public UserAgents toUserAgents() {
        return UserAgents.create().withUiLayer((IUiLayer)UiLayer.HTML).withUiDeviceType((IUiDeviceType)this.getDeviceType()).withUiEngineType((IUiEngineType)this.getEngineType()).withUiSystem((IUiSystem)this.getSystem()).withStandalone(this.isStandalone()).withTouch(this.isMobile() || this.isTablet()).withDeviceId(this.getUserAgent());
    }

    protected UiDeviceType getDeviceType() {
        if (this.isMobile()) {
            return UiDeviceType.MOBILE;
        }
        if (this.isTablet()) {
            return UiDeviceType.TABLET;
        }
        if (this.isDesktop()) {
            return UiDeviceType.DESKTOP;
        }
        return UiDeviceType.UNKNOWN;
    }

    public static HttpClientInfo get(HttpServletRequest request) {
        HttpClientInfo httpClientInfo;
        HttpSession session = request.getSession(false);
        if (session != null && (httpClientInfo = (HttpClientInfo)session.getAttribute(HTTP_CLIENT_INFO_ATTRIBUTE_NAME)) != null) {
            return httpClientInfo;
        }
        String userAgent = request.getHeader("User-Agent");
        HttpClientInfo httpClientInfo2 = HttpClientInfo.createFrom(userAgent);
        if (session != null) {
            session.setAttribute(HTTP_CLIENT_INFO_ATTRIBUTE_NAME, (Object)httpClientInfo2);
        }
        return httpClientInfo2;
    }

    public static HttpClientInfo createFrom(String userAgent) {
        HttpClientInfo info = ((HttpClientInfo)BEANS.get(HttpClientInfo.class)).init(userAgent);
        if (LOG.isTraceEnabled()) {
            LOG.trace(info.toString());
        }
        return info;
    }

    protected static Version extractVersion(String userAgent, String regex) {
        Matcher matcher = Pattern.compile(".*?" + regex + ".*", 42).matcher(userAgent);
        if (matcher.matches()) {
            String s = matcher.group(1);
            return HttpClientInfo.createVersion(s);
        }
        return null;
    }

    protected static Version parseAndroidVersion(String userAgent) {
        return HttpClientInfo.extractVersion(userAgent, "Android\\s([^\\s;]+)");
    }

    protected static Version parseIosVersion(String userAgent) {
        userAgent = userAgent.replace('_', '.');
        return HttpClientInfo.extractVersion(userAgent, "\\sOS\\s([^\\s;]+)");
    }

    protected static Version parseWindowsPhoneVersion(String userAgent) {
        return HttpClientInfo.extractVersion(userAgent, "Windows\\sPhone\\s(?:OS )?([^\\s;]+)");
    }

    protected static Version parseWindowsVersion(String userAgent) {
        return HttpClientInfo.extractVersion(userAgent, "Windows\\sNT\\s([^\\s;]+)");
    }

    protected static Version parseEdgeVersion(String userAgent) {
        return HttpClientInfo.extractVersion(userAgent, "Edge\\/([^\\s;]+)$");
    }

    protected static Version createVersion(String versionString) {
        versionString = versionString.replaceAll("^[/\\s]*", "");
        Matcher matcher = Pattern.compile("([0-9]+)\\.([0-9]+)[\\.]?([0-9]*)").matcher(versionString);
        int[] vArr = new int[3];
        if (matcher.matches()) {
            int i = 1;
            while (i <= 3) {
                String versionPart = matcher.group(i);
                if (StringUtility.hasText((CharSequence)versionPart)) {
                    vArr[i - 1] = Integer.parseInt(versionPart);
                }
                ++i;
            }
        }
        return new Version(vArr[0], vArr[1], vArr[2]);
    }

    public static class Version
    implements Comparable<Version> {
        private final int m_major;
        private final int m_minor;
        private final int m_micro;

        public Version(int major, int minor, int micro) {
            this.m_major = major;
            this.m_minor = minor;
            this.m_micro = micro;
        }

        protected int getMajor() {
            return this.m_major;
        }

        protected int getMinor() {
            return this.m_minor;
        }

        protected int getMicro() {
            return this.m_micro;
        }

        public String toString() {
            return String.valueOf(this.m_major) + "." + this.m_minor + "." + this.m_micro;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.m_major;
            result = 31 * result + this.m_micro;
            result = 31 * result + this.m_minor;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Version other = (Version)obj;
            if (this.m_major != other.m_major) {
                return false;
            }
            if (this.m_micro != other.m_micro) {
                return false;
            }
            return this.m_minor == other.m_minor;
        }

        @Override
        public int compareTo(Version o) {
            if (o == this) {
                return 0;
            }
            if (o == null) {
                return 1;
            }
            int result = this.m_major - o.m_major;
            if (result != 0) {
                return result;
            }
            result = this.m_minor - o.m_minor;
            if (result != 0) {
                return result;
            }
            result = this.m_micro - o.m_micro;
            if (result != 0) {
                return result;
            }
            return 0;
        }
    }
}

