/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.InputStreamContent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.servlet.HttpHeaderNameFilter;
import org.eclipse.scout.rt.server.commons.servlet.HttpProxyRequestOptions;
import org.eclipse.scout.rt.server.commons.servlet.IHttpHeaderFilter;
import org.eclipse.scout.rt.server.commons.servlet.IRewriteRule;
import org.eclipse.scout.rt.shared.http.DefaultHttpTransportManager;
import org.eclipse.scout.rt.shared.http.IHttpTransportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class HttpProxy {
    private static final Logger LOG = LoggerFactory.getLogger(HttpProxy.class);
    private IHttpTransportManager m_httpTransportManager = (IHttpTransportManager)BEANS.get(DefaultHttpTransportManager.class);
    private String m_remoteBaseUrl;
    private final List<IHttpHeaderFilter> m_requestHeaderFilters = new ArrayList<IHttpHeaderFilter>();
    private final List<IHttpHeaderFilter> m_responseHeaderFilters = new ArrayList<IHttpHeaderFilter>();

    @PostConstruct
    protected void initialize() {
        HashSet hopByHopRequestHeaders = CollectionUtility.hashSet((Object[])new String[]{"Connection", "Keep-Alive", "Transfer-Encoding", "Proxy-Authorization", "TE"});
        for (String header : hopByHopRequestHeaders) {
            this.m_requestHeaderFilters.add(new HttpHeaderNameFilter(header));
        }
        HashSet hopByHopResponseHeaders = CollectionUtility.hashSet((Object[])new String[]{"Connection", "Keep-Alive", "Transfer-Encoding", "Proxy-Authenticate", "Trailer"});
        for (String header : hopByHopResponseHeaders) {
            this.m_responseHeaderFilters.add(new HttpHeaderNameFilter(header));
        }
        this.m_requestHeaderFilters.add(new HttpHeaderNameFilter("Content-Length"));
        this.m_requestHeaderFilters.add(new HttpHeaderNameFilter("Host"));
        this.m_responseHeaderFilters.add(new HttpHeaderNameFilter(null));
    }

    protected boolean shouldIncludeRequestPayload(HttpServletRequest req) {
        return ObjectUtility.isOneOf((Object)req.getMethod(), (Object)"POST", (Object[])new Object[]{"PUT"});
    }

    protected boolean shouldWriteParametersAsPayload(HttpServletRequest req) {
        if (req.getParameterMap().isEmpty()) {
            return false;
        }
        String contentType = req.getContentType();
        if (contentType == null) {
            return false;
        }
        int i = contentType.indexOf(";");
        if (i != -1) {
            contentType = contentType.substring(0, i);
        }
        return "application/x-www-form-urlencoded".equalsIgnoreCase(contentType);
    }

    public void proxy(HttpServletRequest req, HttpServletResponse resp, HttpProxyRequestOptions options) throws IOException {
        if (options == null) {
            options = new HttpProxyRequestOptions();
        }
        String url = this.rewriteUrl(req, options);
        HttpRequest httpReq = this.getHttpTransportManager().getHttpRequestFactory().buildRequest(req.getMethod(), new GenericUrl(url), null);
        httpReq = this.prepareRequest(httpReq);
        this.writeRequestHeaders(req, httpReq);
        this.writeCustomRequestHeaders(httpReq, options.getCustomRequestHeaders());
        if (this.shouldIncludeRequestPayload(req)) {
            if (this.shouldWriteParametersAsPayload(req)) {
                this.writeRequestParameters(req, httpReq);
            } else {
                this.writeRequestPayload(req, httpReq);
            }
        }
        HttpResponse httpResp = httpReq.execute();
        this.writeResponseHeaders(resp, httpResp);
        this.writeResponseStatus(resp, httpResp);
        this.writeResponsePayload(resp, httpResp);
        LOG.debug("Forwarded {} request to {}", (Object)req.getMethod(), (Object)url);
    }

    protected String rewriteUrl(HttpServletRequest req, HttpProxyRequestOptions options) {
        String pathInfo = req.getPathInfo();
        IRewriteRule rewriteRule = options.getRewriteRule();
        if (rewriteRule != null) {
            pathInfo = rewriteRule.rewrite(pathInfo);
        }
        return StringUtility.join((String)"", (Object[])new Object[]{this.getRemoteBaseUrl(), pathInfo, StringUtility.box((String)"?", (String)req.getQueryString(), (String)"")});
    }

    protected HttpRequest prepareRequest(HttpRequest httpReq) {
        return httpReq;
    }

    protected void writeRequestHeaders(HttpServletRequest req, HttpRequest httpReq) {
        Enumeration headerNames = req.getHeaderNames();
        Set<String> hopByHopHeaderNames = this.getConnectionHeaderValues(req);
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            String value = req.getHeader(name);
            if (name != null && hopByHopHeaderNames.contains(name.toLowerCase(Locale.US))) {
                LOG.trace("Removed hop-by-hop request header: {} (original value: {})", (Object)name, (Object)req.getHeader(name));
                continue;
            }
            for (IHttpHeaderFilter filter : this.getRequestHeaderFilters()) {
                value = filter.filter(name, value);
            }
            if (value != null) {
                HttpHeaders headers = httpReq.getHeaders();
                headers.set(name, Collections.singletonList(value));
                LOG.trace("Added request header: {}: {}", (Object)name, (Object)value);
                continue;
            }
            LOG.trace("Removed request header: {} (original value: {})", (Object)name, (Object)req.getHeader(name));
        }
    }

    protected void writeCustomRequestHeaders(HttpRequest httpReq, Map<String, String> customHeaders) {
        if (customHeaders == null) {
            return;
        }
        for (Map.Entry<String, String> header : customHeaders.entrySet()) {
            httpReq.getHeaders().set(header.getKey(), (Object)header.getValue());
            LOG.trace("Added custom request header: {}: {}", (Object)header.getValue(), (Object)header.getValue());
        }
    }

    protected void writeRequestPayload(HttpServletRequest req, HttpRequest httpReq) throws IOException {
        httpReq.setContent((HttpContent)new InputStreamContent(null, (InputStream)req.getInputStream()));
    }

    protected void writeRequestParameters(HttpServletRequest req, HttpRequest httpReq) throws IOException {
        String parameters = this.formatFormParameters(req.getParameterMap());
        httpReq.setContent((HttpContent)new InputStreamContent(null, (InputStream)new ByteArrayInputStream(parameters.getBytes(StandardCharsets.UTF_8))));
    }

    protected String formatFormParameters(Map<String, String[]> parameterMap) throws UnsupportedEncodingException {
        StringBuilder parameters = new StringBuilder();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String[] stringArray = entry.getValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (parameters.length() > 0) {
                    parameters.append("&");
                }
                parameters.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.name())).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8.name()));
                ++n2;
            }
        }
        return parameters.toString();
    }

    protected void writeResponsePayload(HttpServletResponse resp, HttpResponse httpResp) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = httpResp.getContent();){
            this.writeResponsePayload(resp, in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void writeResponseStatus(HttpServletResponse resp, HttpResponse httpResp) {
        int responseCode = httpResp.getStatusCode();
        resp.setStatus(responseCode);
    }

    protected void writeResponsePayload(HttpServletResponse resp, InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        IOUtility.writeFromToStream((OutputStream)resp.getOutputStream(), (InputStream)inputStream);
    }

    protected void writeResponseHeaders(HttpServletResponse resp, HttpResponse httpResp) {
        Set<String> hopByHopHeaderNames = this.getConnectionHeaderValues(httpResp);
        for (Map.Entry entry : httpResp.getHeaders().entrySet()) {
            String name = (String)entry.getKey();
            String value = Objects.toString(entry.getValue() instanceof Collection ? CollectionUtility.firstElement((Collection)((Collection)entry.getValue())) : entry.getValue());
            if (name != null && hopByHopHeaderNames.contains(name.toLowerCase(Locale.US))) {
                LOG.trace("Removed hop-by-hop response header: {} (original value: {})", (Object)name, (Object)value);
                continue;
            }
            String originalValue = value;
            for (IHttpHeaderFilter filter : this.getResponseHeaderFilters()) {
                value = filter.filter(name, value);
            }
            if (value != null) {
                resp.setHeader((String)entry.getKey(), value);
                LOG.trace("Added response header: {}: {}", entry.getKey(), (Object)value);
                continue;
            }
            LOG.trace("Removed response header: {} (original value: {})", (Object)name, (Object)originalValue);
        }
    }

    protected Set<String> getConnectionHeaderValues(HttpServletRequest req) {
        Enumeration enumeration = req.getHeaders("Connection");
        if (enumeration == null) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            String s = (String)enumeration.nextElement();
            if (!StringUtility.hasText((CharSequence)s)) continue;
            set.add(s.toLowerCase(Locale.US));
        }
        return set;
    }

    protected Set<String> getConnectionHeaderValues(HttpResponse httpResp) {
        return httpResp.getHeaders().getHeaderStringValues("Connection").stream().flatMap(v -> Stream.of(StringUtility.split((String)v, (String)","))).filter(StringUtility::hasText).map(StringUtility::trim).map(s -> s.toLowerCase(Locale.US)).collect(Collectors.toSet());
    }

    public IHttpTransportManager getHttpTransportManager() {
        return this.m_httpTransportManager;
    }

    public HttpProxy withHttpTransportManager(IHttpTransportManager manager) {
        this.m_httpTransportManager = manager;
        return this;
    }

    public String getRemoteBaseUrl() {
        return this.m_remoteBaseUrl;
    }

    public HttpProxy withRemoteBaseUrl(String remoteBaseUrl) {
        this.m_remoteBaseUrl = remoteBaseUrl;
        return this;
    }

    public List<IHttpHeaderFilter> getRequestHeaderFilters() {
        return this.m_requestHeaderFilters;
    }

    public HttpProxy withRequestHeaderFilter(IHttpHeaderFilter filter) {
        this.m_requestHeaderFilters.add(filter);
        return this;
    }

    public List<IHttpHeaderFilter> getResponseHeaderFilters() {
        return this.m_responseHeaderFilters;
    }

    public HttpProxy withResponseHeaderFilter(IHttpHeaderFilter filter) {
        this.m_responseHeaderFilters.add(filter);
        return this;
    }
}

