/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.eclipse.scout.rt.server.commons.servlet.UrlHintsHelper;

@Bean
public class UrlHints
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final LazyValue<UrlHintsHelper> URL_HINTS_HELPER = new LazyValue(UrlHintsHelper.class);
    private static final String URL_PARAM_DEBUG = "debug";
    private static final String URL_PARAM_CACHE_HINT = "cache";
    private static final String URL_PARAM_COMPRESS_HINT = "compress";
    private static final String URL_PARAM_MINIFY_HINT = "minify";
    private static final String URL_PARAM_INSPECTOR_HINT = "inspector";
    private static final Pattern COOKIE_STRING_PATTERN = Pattern.compile("C([01])Z([01])M([01])I([01])");
    private boolean m_cache;
    private boolean m_compress;
    private boolean m_minify;
    private boolean m_inspector;
    private boolean m_changed = false;
    private boolean m_readOnly = false;

    @PostConstruct
    protected void initDefaults() {
        this.m_cache = !Platform.get().inDevelopmentMode();
        this.m_compress = true;
        this.m_minify = !Platform.get().inDevelopmentMode();
        this.m_inspector = Platform.get().inDevelopmentMode();
    }

    public boolean isCache() {
        return this.m_cache;
    }

    public void setCache(boolean cache) {
        this.assertWritable();
        if (this.m_cache != cache) {
            this.m_cache = cache;
            this.m_changed = true;
        }
    }

    public boolean isCompress() {
        return this.m_compress;
    }

    public void setCompress(boolean compress) {
        this.assertWritable();
        if (this.m_compress != compress) {
            this.m_compress = compress;
            this.m_changed = true;
        }
    }

    public boolean isMinify() {
        return this.m_minify;
    }

    public void setMinify(boolean minify) {
        this.assertWritable();
        if (this.m_minify != minify) {
            this.m_minify = minify;
            this.m_changed = true;
        }
    }

    public boolean isInspector() {
        return this.m_inspector;
    }

    public void setInspector(boolean inspector) {
        this.assertWritable();
        if (this.m_inspector != inspector) {
            this.m_inspector = inspector;
            this.m_changed = true;
        }
    }

    public boolean isChanged() {
        return this.m_changed;
    }

    public void setChanged(boolean changed) {
        this.assertWritable();
        this.m_changed = changed;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setReadOnly() {
        this.m_readOnly = true;
    }

    protected void assertWritable() {
        Assertions.assertFalse((boolean)this.m_readOnly, (String)"Object is read-only", (Object[])new Object[0]);
    }

    public void setFromUrlParams(HttpServletRequest req) {
        Boolean paramDebug = this.getRequestParameterBoolean(req, URL_PARAM_DEBUG);
        Boolean paramCache = this.getRequestParameterBoolean(req, URL_PARAM_CACHE_HINT);
        Boolean paramCompress = this.getRequestParameterBoolean(req, URL_PARAM_COMPRESS_HINT);
        Boolean paramMinify = this.getRequestParameterBoolean(req, URL_PARAM_MINIFY_HINT);
        Boolean paramInspector = this.getRequestParameterBoolean(req, URL_PARAM_INSPECTOR_HINT);
        if (paramDebug != null) {
            this.setCache(paramDebug == false);
            this.setCompress(paramDebug == false);
            this.setMinify(paramDebug == false);
            this.setInspector(paramDebug);
        }
        if (paramCache != null) {
            this.setCache(paramCache);
        }
        if (paramCompress != null) {
            this.setCompress(paramCompress);
        }
        if (paramMinify != null) {
            this.setMinify(paramMinify);
        }
        if (paramInspector != null) {
            this.setInspector(paramInspector);
        }
    }

    protected Boolean getRequestParameterBoolean(HttpServletRequest req, String parameterName) {
        String s = req.getParameter(parameterName);
        if (s == null) {
            return null;
        }
        return (Boolean)TypeCastUtility.castValue((Object)s, Boolean.class);
    }

    public String toCookieString() {
        return "C" + (this.m_cache ? "1" : "0") + "Z" + (this.m_compress ? "1" : "0") + "M" + (this.m_minify ? "1" : "0") + "I" + (this.m_inspector ? "1" : "0");
    }

    public void setFromCookieString(String cookieString) {
        if (cookieString == null) {
            return;
        }
        Matcher m = COOKIE_STRING_PATTERN.matcher(cookieString);
        if (m.matches()) {
            this.setCache("1".equals(m.group(1)));
            this.setCompress("1".equals(m.group(2)));
            this.setMinify("1".equals(m.group(3)));
            this.setInspector("1".equals(m.group(4)));
        }
    }

    public String toHumanReadableString() {
        return "cache=" + this.m_cache + ", compress=" + this.m_compress + ", minify=" + this.m_minify + ", inspector=" + this.m_inspector;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_cache ? 1231 : 1237);
        result = 31 * result + (this.m_compress ? 1231 : 1237);
        result = 31 * result + (this.m_minify ? 1231 : 1237);
        result = 31 * result + (this.m_inspector ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UrlHints other = (UrlHints)obj;
        if (this.m_cache != other.m_cache) {
            return false;
        }
        if (this.m_compress != other.m_compress) {
            return false;
        }
        if (this.m_minify != other.m_minify) {
            return false;
        }
        return this.m_inspector == other.m_inspector;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        this.interceptToStringBuilder(builder);
        return builder.toString();
    }

    protected void interceptToStringBuilder(ToStringBuilder builder) {
        builder.attr(URL_PARAM_CACHE_HINT, this.m_cache).attr(URL_PARAM_COMPRESS_HINT, this.m_compress).attr(URL_PARAM_MINIFY_HINT, this.m_minify).attr(URL_PARAM_INSPECTOR_HINT, this.m_inspector).attr("changed", this.m_changed).attr("readOnly", this.m_readOnly);
    }

    public static void updateHints(HttpServletRequest req, HttpServletResponse resp) {
        ((UrlHintsHelper)URL_HINTS_HELPER.get()).updateHints(req, resp);
    }

    public static boolean isCacheHint(HttpServletRequest req) {
        return ((UrlHintsHelper)URL_HINTS_HELPER.get()).isCacheHint(req);
    }

    public static boolean isCompressHint(HttpServletRequest req) {
        return ((UrlHintsHelper)URL_HINTS_HELPER.get()).isCompressHint(req);
    }

    public static boolean isMinifyHint(HttpServletRequest req) {
        return ((UrlHintsHelper)URL_HINTS_HELPER.get()).isMinifyHint(req);
    }

    public static boolean isInspectorHint(HttpServletRequest req) {
        return ((UrlHintsHelper)URL_HINTS_HELPER.get()).isInspectorHint(req);
    }
}

