/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.authentication;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.Base64Utility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.SleepUtil;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.authentication.IAccessController;
import org.eclipse.scout.rt.server.commons.authentication.ServletFilterHelper;
import org.eclipse.scout.rt.server.commons.authentication.token.ITokenPrincipalProducer;
import org.eclipse.scout.rt.server.commons.authentication.token.ITokenVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class BearerAuthAccessController
implements IAccessController {
    public static final String HTTP_BEARER_AUTH_NAME = "Bearer";
    private static final Logger LOG = LoggerFactory.getLogger(BearerAuthAccessController.class);
    protected HttpBearerAuthConfig m_config;

    public BearerAuthAccessController init(HttpBearerAuthConfig config) {
        this.m_config = config;
        Assertions.assertNotNull((Object)this.m_config.getTokenVerifier(), (String)"TokenVerifier must not be null", (Object[])new Object[0]);
        return this;
    }

    @Override
    public boolean handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.m_config.isEnabled()) {
            return false;
        }
        return this.handleInternal(request, response, chain);
    }

    @Override
    public void destroy() {
    }

    protected boolean handleInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        List<byte[]> bearerTokenParts = this.readBearerToken(request);
        if (CollectionUtility.isEmpty(bearerTokenParts)) {
            this.handleForbidden(8, response);
            return true;
        }
        int status = this.m_config.getTokenVerifier().verify(bearerTokenParts);
        if (status != 1) {
            this.handleForbidden(status, response);
            return true;
        }
        if (this.m_config.getPrincipalProducer() != null) {
            Principal principal = this.m_config.getPrincipalProducer().produce(bearerTokenParts);
            ((ServletFilterHelper)BEANS.get(ServletFilterHelper.class)).continueChainAsSubject(principal, request, response, chain);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        return true;
    }

    protected void handleForbidden(int status, HttpServletResponse resp) throws IOException {
        if (status == 8) {
            resp.addHeader("WWW-Authenticate", HTTP_BEARER_AUTH_NAME);
            resp.sendError(401);
        } else {
            if (this.m_config.getStatus403WaitMillis() > 0L) {
                SleepUtil.sleepSafe((long)this.m_config.getStatus403WaitMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
            }
            resp.sendError(403);
        }
    }

    protected List<byte[]> readBearerToken(HttpServletRequest req) {
        String bearerToken = this.parseBearerAuthRequest(req);
        if (StringUtility.isNullOrEmpty((CharSequence)bearerToken)) {
            return null;
        }
        String[] encodedBearerTokenParts = StringUtility.split((String)bearerToken, (String)"[-._~]");
        ArrayList<byte[]> tokenParts = new ArrayList<byte[]>();
        int i = 0;
        while (i < encodedBearerTokenParts.length) {
            String encodedPart = encodedBearerTokenParts[i];
            try {
                tokenParts.add(Base64Utility.decode((String)encodedPart));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Token is not a valid base64 encoded value. Check part {} of the token", (Object)i, (Object)e);
            }
            ++i;
        }
        return tokenParts;
    }

    public String parseBearerAuthRequest(HttpServletRequest req) {
        String h = req.getHeader("Authorization");
        if (h == null || !h.startsWith("Bearer ")) {
            return null;
        }
        return h.substring(HTTP_BEARER_AUTH_NAME.length() + 1);
    }

    public static class HttpBearerAuthConfig {
        private boolean m_enabled = true;
        private ITokenVerifier m_tokenVerifier;
        private ITokenPrincipalProducer m_principalProducer = null;
        private long m_status403WaitMillis = 500L;

        public boolean isEnabled() {
            return this.m_enabled;
        }

        public HttpBearerAuthConfig withEnabled(boolean enabled) {
            this.m_enabled = enabled;
            return this;
        }

        public ITokenVerifier getTokenVerifier() {
            return this.m_tokenVerifier;
        }

        public HttpBearerAuthConfig withTokenVerifier(ITokenVerifier tokenVerifier) {
            this.m_tokenVerifier = tokenVerifier;
            return this;
        }

        public ITokenPrincipalProducer getPrincipalProducer() {
            return this.m_principalProducer;
        }

        public HttpBearerAuthConfig withPrincipalProducer(ITokenPrincipalProducer principalProducer) {
            this.m_principalProducer = principalProducer;
            return this;
        }

        public long getStatus403WaitMillis() {
            return this.m_status403WaitMillis;
        }

        public HttpBearerAuthConfig withStatus403WaitMillis(long waitMillis) {
            this.m_status403WaitMillis = waitMillis;
            return this;
        }
    }
}

