/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.authentication;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.security.IPrincipalProducer;
import org.eclipse.scout.rt.platform.util.Base64Utility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.UriUtility;
import org.eclipse.scout.rt.server.commons.authentication.SecureHttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ServletFilterHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ServletFilterHelper.class);
    public static final String SESSION_ATTRIBUTE_FOR_PRINCIPAL = String.valueOf(ServletFilterHelper.class.getName()) + ".PRINCIPAL";
    public static final String SESSION_ATTRIBUTE_FOR_LOGIN_REDIRECT = String.valueOf(ServletFilterHelper.class.getName()) + ".LOGIN_REDIRECT";
    public static final String HTTP_HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String HTTP_HEADER_AUTHORIZATION = "Authorization";
    public static final String HTTP_HEADER_AUTHORIZED = "Authorized";
    public static final String HTTP_BASIC_AUTH_NAME = "Basic";
    public static final Charset HTTP_BASIC_AUTH_CHARSET = StandardCharsets.ISO_8859_1;
    public static final String JSON_SESSION_TIMEOUT_RESPONSE = "{\"error\":{\"code\":10,\"message\":\"The session has expired, please reload the page.\"}}";
    public static final Set<String> IDEMPOTENT_HTTP_REQUEST_METHODS = Arrays.stream(new String[]{"GET", "HEAD", "PUT", "DELETE", "OPTIONS", "TRACE"}).collect(Collectors.toSet());

    public boolean redirectIncompleteBasePath(HttpServletRequest request, HttpServletResponse response, boolean includeServletPath) throws IOException {
        if (this.isIdempotent(request)) {
            String path = request.getServletContext().getContextPath();
            if (includeServletPath) {
                path = String.valueOf(path) + request.getServletPath();
            }
            if (StringUtility.hasText((CharSequence)path) && request.getRequestURI().endsWith(path)) {
                String uri = String.valueOf(request.getRequestURI()) + "/";
                if (StringUtility.hasText((CharSequence)request.getQueryString())) {
                    uri = String.valueOf(uri) + "?" + request.getQueryString();
                }
                response.sendRedirect(uri);
                return true;
            }
        }
        return false;
    }

    public boolean isIdempotent(HttpServletRequest request) {
        return IDEMPOTENT_HTTP_REQUEST_METHODS.contains(request.getMethod());
    }

    public Principal getPrincipalOnSession(HttpServletRequest req) {
        Principal principal;
        HttpSession session = req.getSession(false);
        if (session != null && (principal = (Principal)session.getAttribute(SESSION_ATTRIBUTE_FOR_PRINCIPAL)) != null) {
            return principal;
        }
        return null;
    }

    public void putPrincipalOnSession(HttpServletRequest req, Principal principal) {
        HttpSession session = req.getSession();
        session.setAttribute(SESSION_ATTRIBUTE_FOR_PRINCIPAL, (Object)principal);
    }

    public boolean isRunningWithValidSubject(HttpServletRequest req) {
        String username = req.getRemoteUser();
        if (username == null || username.isEmpty()) {
            return false;
        }
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null || subject.getPrincipals().isEmpty()) {
            return false;
        }
        for (Principal principal : subject.getPrincipals()) {
            if (!username.equalsIgnoreCase(principal.getName())) continue;
            return true;
        }
        return false;
    }

    public Principal findPrincipal(HttpServletRequest servletRequest, IPrincipalProducer principalProducer) {
        Principal principal = this.getPrincipalOnSession(servletRequest);
        if (principal != null) {
            return principal;
        }
        principal = servletRequest.getUserPrincipal();
        if (principal != null && StringUtility.hasText((CharSequence)principal.getName())) {
            return principal;
        }
        String name = servletRequest.getRemoteUser();
        if (StringUtility.hasText((CharSequence)name)) {
            return principalProducer.produce(name);
        }
        return null;
    }

    public Subject createSubject(Principal principal) {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null || subject.isReadOnly()) {
            subject = new Subject();
        }
        subject.getPrincipals().add(principal);
        subject.setReadOnly();
        return subject;
    }

    public void continueChainAsSubject(Principal principal, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        try {
            Subject.doAs(this.createSubject(principal), () -> {
                SecureHttpServletRequestWrapper secureReq = new SecureHttpServletRequestWrapper(req, principal);
                chain.doFilter((ServletRequest)secureReq, (ServletResponse)res);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }

    public String createBasicAuthRequest(String username, char[] password) {
        String cred = String.valueOf(username) + ":" + String.valueOf(password);
        String encodedCred = Base64Utility.encode((byte[])cred.getBytes(HTTP_BASIC_AUTH_CHARSET));
        return "Basic " + encodedCred;
    }

    public String[] parseBasicAuthRequest(HttpServletRequest req) {
        String h = req.getHeader(HTTP_HEADER_AUTHORIZATION);
        if (h == null || !h.startsWith("Basic ")) {
            return null;
        }
        return new String(Base64Utility.decode((String)h.substring(HTTP_BASIC_AUTH_NAME.length() + 1)), HTTP_BASIC_AUTH_CHARSET).split(":", 2);
    }

    public void forwardToLoginForm(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (!this.acceptForwardOrRedirect(req, resp, req.getPathInfo(), true)) {
            return;
        }
        if (this.redirectToLoginFormIfNecessary(req, resp)) {
            return;
        }
        this.forwardTo(req, resp, "/login.html");
    }

    protected boolean redirectToLoginFormIfNecessary(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String pathInfo = req.getPathInfo();
        if (pathInfo.length() > 1 && pathInfo.substring(1).contains("/")) {
            pathInfo = this.encodePathInfo(pathInfo);
            if (req.getQueryString() != null) {
                pathInfo = String.valueOf(pathInfo) + "?" + req.getQueryString();
            }
            req.getSession(true).setAttribute(SESSION_ATTRIBUTE_FOR_LOGIN_REDIRECT, (Object)pathInfo);
            this.redirectTo(req, resp, "/login");
            return true;
        }
        return false;
    }

    public String encodePathInfo(String pathInfo) {
        if (pathInfo == null) {
            return null;
        }
        String encodedPathInfo = Arrays.stream(pathInfo.split("/")).map(UriUtility::encode).collect(Collectors.joining("/"));
        if (pathInfo.endsWith("/")) {
            encodedPathInfo = String.valueOf(encodedPathInfo) + "/";
        }
        return encodedPathInfo;
    }

    public void forwardToLogoutForm(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.forwardTo(req, resp, "/logout.html");
    }

    public void forwardTo(HttpServletRequest req, HttpServletResponse resp, String targetLocation) throws IOException, ServletException {
        this.forwardOrRedirectTo(req, resp, targetLocation, false);
    }

    public void redirectTo(HttpServletRequest req, HttpServletResponse resp, String targetLocation) throws IOException, ServletException {
        this.forwardOrRedirectTo(req, resp, targetLocation, true);
    }

    protected void forwardOrRedirectTo(HttpServletRequest req, HttpServletResponse resp, String targetLocation, boolean redirect) throws IOException, ServletException {
        if (!this.acceptForwardOrRedirect(req, resp, targetLocation, redirect)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.valueOf(redirect ? "Redirecting" : "Forwarding") + " '{}' to '{}'", (Object)req.getPathInfo(), (Object)targetLocation);
        }
        if (redirect) {
            resp.sendRedirect(targetLocation);
        } else {
            req.getRequestDispatcher(targetLocation).forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    protected boolean acceptForwardOrRedirect(HttpServletRequest req, HttpServletResponse resp, String targetLocation, boolean redirect) throws IOException {
        String acceptedMimeTypes = req.getHeader("Accept");
        if (StringUtility.containsString((String)acceptedMimeTypes, (String)"application/json")) {
            LOG.debug("Returning session timeout error as json for path {}, based on Accept header {}.", (Object)req.getPathInfo(), (Object)acceptedMimeTypes);
            this.sendJsonSessionTimeout(resp);
            return false;
        }
        if (!ObjectUtility.isOneOf((Object)req.getMethod(), (Object)"GET", (Object[])new Object[]{"HEAD"})) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The request for '{}' is a {} request. " + (redirect ? "Redirecting" : "Forwarding") + " to '{}' will most likely fail. Sending HTTP status '403 Forbidden' instead.", new Object[]{req.getPathInfo(), req.getMethod(), targetLocation});
            }
            resp.sendError(403);
            return false;
        }
        return true;
    }

    protected void sendJsonSessionTimeout(HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resp.getWriter().print(JSON_SESSION_TIMEOUT_RESPONSE);
    }

    public void doLogout(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            LOG.info("Invalidating HTTP session with ID {}", (Object)session.getId());
            session.invalidate();
        }
    }

    public void invalidateSessionAfterLogin(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        Object redirectUrl = session.getAttribute(SESSION_ATTRIBUTE_FOR_LOGIN_REDIRECT);
        session.invalidate();
        if (redirectUrl != null) {
            request.getSession().setAttribute(SESSION_ATTRIBUTE_FOR_LOGIN_REDIRECT, redirectUrl);
        }
    }

    public boolean redirectAfterLogin(HttpServletRequest request, HttpServletResponse response, ServletFilterHelper helper) throws IOException, ServletException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        Object redirectPath = session.getAttribute(SESSION_ATTRIBUTE_FOR_LOGIN_REDIRECT);
        if (redirectPath != null) {
            session.removeAttribute(SESSION_ATTRIBUTE_FOR_LOGIN_REDIRECT);
            helper.redirectTo(request, response, (String)redirectPath);
            return true;
        }
        return false;
    }
}

