/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.server.commons.ServerCommonsConfigProperties;
import org.eclipse.scout.rt.server.commons.servlet.ContentSecurityPolicy;
import org.eclipse.scout.rt.server.commons.servlet.HttpClientInfo;
import org.eclipse.scout.rt.server.commons.servlet.UrlHints;

@ApplicationScoped
public class HttpServletControl
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String HTTP_HEADER_X_FRAME_OPTIONS = "X-Frame-Options";
    public static final String SAMEORIGIN = "SAMEORIGIN";
    public static final String HTTP_HEADER_X_XSS_PROTECTION = "X-XSS-Protection";
    public static final String XSS_MODE_BLOCK = "1; mode=block";
    public static final String HTTP_HEADER_CSP = "Content-Security-Policy";
    public static final String HTTP_HEADER_CSP_LEGACY = "X-Content-Security-Policy";
    public static final String CSP_REPORT_URL = "csp-report";
    public static final String HTTP_HEADER_X_CONTENT_TYPE_OPTIONS = "X-Content-Type-Options";
    public static final String CONTENT_TYPE_OPTION_NO_SNIFF = "nosniff";
    private String m_cspToken;

    @PostConstruct
    protected void buildCspPolicyToken() {
        this.setCspToken(((ContentSecurityPolicy)BEANS.get(ContentSecurityPolicy.class)).toToken());
    }

    protected final String getCspToken() {
        return this.m_cspToken;
    }

    protected final void setCspToken(String cspToken) {
        this.m_cspToken = cspToken;
    }

    public void doDefaults(HttpServlet servlet, HttpServletRequest req, HttpServletResponse resp) {
        this.parseRequest(servlet, req, resp);
        this.setResponseHeaders(servlet, req, resp);
    }

    protected void parseRequest(HttpServlet servlet, HttpServletRequest req, HttpServletResponse resp) {
        UrlHints.updateHints(req, resp);
    }

    protected void setResponseHeaders(HttpServlet servlet, HttpServletRequest req, HttpServletResponse resp) {
        resp.setHeader(HTTP_HEADER_X_CONTENT_TYPE_OPTIONS, CONTENT_TYPE_OPTION_NO_SNIFF);
        if (!"GET".equals(req.getMethod())) {
            return;
        }
        resp.setHeader(HTTP_HEADER_X_FRAME_OPTIONS, SAMEORIGIN);
        resp.setHeader(HTTP_HEADER_X_XSS_PROTECTION, XSS_MODE_BLOCK);
        if (this.isCspEnabled(req)) {
            if (HttpClientInfo.get(req).isMshtml()) {
                resp.setHeader(HTTP_HEADER_CSP_LEGACY, this.getCspToken());
            } else {
                resp.setHeader(HTTP_HEADER_CSP, this.getCspToken());
            }
        }
    }

    protected boolean isCspEnabled(HttpServletRequest req) {
        if (!((Boolean)CONFIG.getPropertyValue(ServerCommonsConfigProperties.CspEnabledProperty.class)).booleanValue()) {
            return false;
        }
        List exclusions = (List)CONFIG.getPropertyValue(ServerCommonsConfigProperties.CspExclusionsProperty.class);
        String pathInfo = req.getPathInfo();
        if (exclusions == null || pathInfo == null) {
            return true;
        }
        for (Pattern exclusion : exclusions) {
            if (!exclusion.matcher(pathInfo).matches()) continue;
            return false;
        }
        return true;
    }
}

