/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet.cache;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheKey;
import org.eclipse.scout.rt.server.commons.servlet.cache.IHttpResponseInterceptor;

public class HttpCacheObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final HttpCacheKey m_cacheKey;
    private final BinaryResource m_resource;
    private final Set<IHttpResponseInterceptor> m_httpResponseInterceptors = new HashSet<IHttpResponseInterceptor>();

    public HttpCacheObject(HttpCacheKey cacheKey, BinaryResource resource) {
        this.m_cacheKey = (HttpCacheKey)Assertions.assertNotNull((Object)cacheKey);
        this.m_resource = (BinaryResource)Assertions.assertNotNull((Object)resource);
    }

    public HttpCacheKey getCacheKey() {
        return this.m_cacheKey;
    }

    public boolean isCachingAllowed() {
        return this.m_resource.isCachingAllowed();
    }

    public int getCacheMaxAge() {
        return this.m_resource.getCacheMaxAge();
    }

    public BinaryResource getResource() {
        return this.m_resource;
    }

    public String createETag() {
        if (this.m_resource.getFingerprint() != -1L && (long)this.m_resource.getContentLength() != -1L) {
            return "W/\"" + this.m_resource.getContentLength() + "-" + this.m_resource.getFingerprint() + "\"";
        }
        return null;
    }

    public void addHttpResponseInterceptor(IHttpResponseInterceptor interceptor) {
        this.m_httpResponseInterceptors.add(interceptor);
    }

    public void removeHttpResponseInterceptor(IHttpResponseInterceptor interceptor) {
        this.m_httpResponseInterceptors.remove(interceptor);
    }

    public void applyHttpResponseInterceptors(HttpServletRequest req, HttpServletResponse resp) {
        if (resp != null) {
            for (IHttpResponseInterceptor interceptor : this.m_httpResponseInterceptors) {
                interceptor.intercept(req, resp);
            }
        }
    }
}

