/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.server.runner.statement;

import org.eclipse.scout.rt.platform.transaction.TransactionScope;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;
import org.eclipse.scout.rt.server.clientnotification.ClientNotificationCollector;
import org.eclipse.scout.rt.server.context.ServerRunContexts;
import org.eclipse.scout.rt.testing.platform.runner.SafeStatementInvoker;
import org.eclipse.scout.rt.testing.server.runner.RunWithClientNotifications;
import org.junit.runners.model.Statement;

public class ClientNotificationsStatement
extends Statement {
    private final Statement m_next;
    private final String m_clientNodeId;
    private final ClientNotificationCollector m_collector;

    public ClientNotificationsStatement(Statement next, RunWithClientNotifications annotation) {
        this.m_next = (Statement)Assertions.assertNotNull((Object)next, (String)"next statement must not be null", (Object[])new Object[0]);
        this.m_clientNodeId = annotation != null ? annotation.clientNodeId() : null;
        this.m_collector = new ClientNotificationCollector();
    }

    public void evaluate() throws Throwable {
        SafeStatementInvoker invoker = new SafeStatementInvoker(this.m_next);
        ServerRunContexts.copyCurrent().withClientNotificationCollector(this.m_collector).withTransactionScope(TransactionScope.REQUIRES_NEW).withClientNodeId(this.m_clientNodeId).run((IRunnable)invoker);
        invoker.throwOnError();
    }
}

