/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.basic;

import java.io.Serializable;
import java.util.StringTokenizer;

public class FontSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    private final String m_name;
    private final int m_style;
    private final int m_size;

    public FontSpec(String name, int style, int size) {
        this.m_name = name;
        this.m_style = style;
        this.m_size = size;
    }

    public String toPattern() {
        return String.valueOf(this.getName()) + (this.isPlain() ? "-PLAIN" : "") + (this.isBold() ? "-BOLD" : "") + (this.isItalic() ? "-ITALIC" : "") + "-" + this.getSize();
    }

    public String getName() {
        return this.m_name;
    }

    public int getStyle() {
        return this.m_style;
    }

    public boolean isPlain() {
        return this.m_style == 0;
    }

    public boolean isBold() {
        return (this.m_style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.m_style & 2) != 0;
    }

    public int getSize() {
        return this.m_size;
    }

    public FontSpec getPlainCopy() {
        return new FontSpec(this.m_name, 0, this.m_size);
    }

    public FontSpec getBoldCopy() {
        return new FontSpec(this.m_name, this.m_style | 1, this.m_size);
    }

    public FontSpec getItalicCopy() {
        return new FontSpec(this.m_name, this.m_style | 2, this.m_size);
    }

    public static FontSpec parse(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return null;
        }
        String newName = null;
        int newStyle = 0;
        int newSize = 0;
        StringTokenizer tok = new StringTokenizer(pattern, " -_,/.;");
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken().toUpperCase();
            if ("PLAIN".equals(s)) continue;
            if ("BOLD".equals(s)) {
                newStyle |= 1;
                continue;
            }
            if ("ITALIC".equals(s)) {
                newStyle |= 2;
                continue;
            }
            try {
                newSize = Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                newName = s;
            }
        }
        if ("null".equalsIgnoreCase(newName)) {
            newName = null;
        }
        return new FontSpec(newName, newStyle, newSize);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + this.m_size;
        result = 31 * result + this.m_style;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FontSpec other = (FontSpec)obj;
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return false;
        }
        if (this.m_size != other.m_size) {
            return false;
        }
        return this.m_style == other.m_style;
    }
}

