/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.form;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.classid.ClassIdentifier;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.holders.IHolder;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CloneUtility;
import org.eclipse.scout.rt.shared.data.form.FormDataUtility;
import org.eclipse.scout.rt.shared.data.form.IPropertyHolder;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData;
import org.eclipse.scout.rt.shared.extension.AbstractContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;

@Bean
public abstract class AbstractFormData
extends AbstractContributionComposite
implements IPropertyHolder {
    public static final char FIELD_PATH_DELIM = '/';
    private static final long serialVersionUID = 1L;
    private Map<Class<?>, Class<? extends AbstractFormFieldData>> m_fieldDataReplacements;
    private Map<Class<? extends AbstractPropertyData>, AbstractPropertyData> m_propertyMap;
    private Map<Class<? extends AbstractFormFieldData>, AbstractFormFieldData> m_fieldMap;

    private List<Class<AbstractPropertyData>> getConfiguredPropertyDatas() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, AbstractPropertyData.class);
    }

    private List<Class<? extends AbstractFormFieldData>> getConfiguredFieldDatas() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fca = ConfigurationUtility.filterClasses((Class[])dca, AbstractFormFieldData.class);
        return ConfigurationUtility.removeReplacedClasses((List)fca);
    }

    @Override
    protected void initConfig() {
        List<Class<AbstractPropertyData>> configuredPropertyDatas = this.getConfiguredPropertyDatas();
        HashMap<Class<? extends AbstractPropertyData>, AbstractPropertyData> propMap = new HashMap<Class<? extends AbstractPropertyData>, AbstractPropertyData>(configuredPropertyDatas.size());
        for (Class<AbstractPropertyData> propertyDataClazz : configuredPropertyDatas) {
            AbstractPropertyData p = (AbstractPropertyData)ConfigurationUtility.newInnerInstance((Object)this, propertyDataClazz);
            propMap.put(p.getClass(), p);
        }
        if (!propMap.isEmpty()) {
            this.m_propertyMap = propMap;
        }
        List<Class<? extends AbstractFormFieldData>> formFieldDataClazzes = this.getConfiguredFieldDatas();
        this.m_fieldMap = new HashMap<Class<? extends AbstractFormFieldData>, AbstractFormFieldData>(formFieldDataClazzes.size());
        Map replacements = ConfigurationUtility.getReplacementMapping(formFieldDataClazzes);
        if (!replacements.isEmpty()) {
            this.m_fieldDataReplacements = replacements;
        }
        for (Class<? extends AbstractFormFieldData> formFieldDataClazz : formFieldDataClazzes) {
            AbstractFormFieldData f = (AbstractFormFieldData)ConfigurationUtility.newInnerInstance((Object)this, formFieldDataClazz);
            this.m_fieldMap.put(f.getClass(), f);
        }
    }

    @Override
    public AbstractPropertyData getPropertyById(String id) {
        if (this.m_propertyMap == null) {
            return null;
        }
        for (AbstractPropertyData p : this.m_propertyMap.values()) {
            if (!p.getPropertyId().equalsIgnoreCase(id)) continue;
            return p;
        }
        return null;
    }

    @Override
    public <T extends AbstractPropertyData> T getPropertyByClass(Class<T> c) {
        if (this.m_propertyMap == null) {
            return null;
        }
        return (T)this.m_propertyMap.get(c);
    }

    @Override
    public <T extends AbstractPropertyData> void setPropertyByClass(Class<T> c, T v) {
        if (v == null) {
            if (this.m_propertyMap != null) {
                this.m_propertyMap.remove(c);
            }
        } else {
            if (this.m_propertyMap == null) {
                this.m_propertyMap = new HashMap<Class<? extends AbstractPropertyData>, AbstractPropertyData>();
            }
            this.m_propertyMap.put(c, v);
        }
    }

    @Override
    public AbstractPropertyData[] getAllProperties() {
        return this.m_propertyMap != null ? this.m_propertyMap.values().toArray(new AbstractPropertyData[0]) : new AbstractPropertyData[]{};
    }

    public AbstractFormFieldData getFieldById(String id) {
        String fieldDataId = FormDataUtility.getFieldDataId(id);
        for (AbstractFormFieldData f : this.m_fieldMap.values()) {
            if (!f.getFieldId().equals(fieldDataId)) continue;
            return f;
        }
        return null;
    }

    public <T extends AbstractFormFieldData> T getFieldByClass(Class<T> c) {
        Class<T> clazz = this.getReplacingFieldDataClass(c);
        return (T)this.m_fieldMap.get(clazz);
    }

    public <T extends AbstractFormFieldData> void setFieldByClass(Class<T> c, T v) {
        Class<T> clazz = this.getReplacingFieldDataClass(c);
        if (v == null) {
            this.m_fieldMap.remove(clazz);
        } else {
            this.m_fieldMap.put(clazz, v);
        }
    }

    private <T extends AbstractFormFieldData> Class<? extends T> getReplacingFieldDataClass(Class<T> c) {
        Class<? extends AbstractFormFieldData> replacingFieldDataClass;
        if (this.m_fieldDataReplacements != null && (replacingFieldDataClass = this.m_fieldDataReplacements.get(c)) != null) {
            return replacingFieldDataClass;
        }
        return c;
    }

    public AbstractFormFieldData[] getFields() {
        return this.m_fieldMap.values().toArray(new AbstractFormFieldData[0]);
    }

    public Map<Integer, Map<String, AbstractFormFieldData>> getAllFieldsRec() {
        TreeMap<Integer, Map<String, AbstractFormFieldData>> breadthFirstMap = new TreeMap<Integer, Map<String, AbstractFormFieldData>>();
        AbstractFormFieldData[] abstractFormFieldDataArray = this.getFields();
        int n = abstractFormFieldDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFormFieldData child = abstractFormFieldDataArray[n2];
            AbstractFormData.collectAllFieldsRec(child, breadthFirstMap, 0, "", false);
            ++n2;
        }
        AbstractFormData.collectFieldDatasInContributions(this, breadthFirstMap, "");
        return breadthFirstMap;
    }

    private static void collectFieldDatasInContributions(IContributionOwner comp, Map<Integer, Map<String, AbstractFormFieldData>> breadthFirstMap, String prefix) {
        AbstractFormData.collectInContributedFormDatas(comp.getContributionsByClass(AbstractFormData.class), breadthFirstMap, prefix);
        AbstractFormData.collectInContributedFormFieldDatas(comp.getContributionsByClass(AbstractFormFieldData.class), breadthFirstMap, prefix);
    }

    private static void collectInContributedFormFieldDatas(Collection<AbstractFormFieldData> contributions, Map<Integer, Map<String, AbstractFormFieldData>> breadthFirstMap, String prefix) {
        for (AbstractFormFieldData ffd : contributions) {
            AbstractFormData.collectAllFieldsRec(ffd, breadthFirstMap, 0, prefix, !(ffd instanceof IHolder));
        }
    }

    private static void collectInContributedFormDatas(Collection<AbstractFormData> contributions, Map<Integer, Map<String, AbstractFormFieldData>> breadthFirstMap, String prefix) {
        for (AbstractFormData fd : contributions) {
            AbstractFormFieldData[] abstractFormFieldDataArray = fd.getFields();
            int n = abstractFormFieldDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractFormFieldData child = abstractFormFieldDataArray[n2];
                AbstractFormData.collectAllFieldsRec(child, breadthFirstMap, 0, prefix, false);
                ++n2;
            }
        }
    }

    private static void collectAllFieldsRec(AbstractFormFieldData field, Map<Integer, Map<String, AbstractFormFieldData>> breadthFirstMap, int level, String prefix, boolean isContributionTopLevelContainer) {
        Map subMap = breadthFirstMap.computeIfAbsent(level, k -> new HashMap());
        boolean isTopLevel = field.getClass().getDeclaringClass() == null;
        String fieldId = null;
        fieldId = isTopLevel || isContributionTopLevelContainer ? FormDataUtility.getFieldDataId(field) : field.getFieldId();
        if (!isContributionTopLevelContainer) {
            subMap.put(String.valueOf(prefix) + fieldId, field);
        }
        String fieldPrefix = prefix;
        if (!isContributionTopLevelContainer) {
            fieldPrefix = String.valueOf(prefix) + fieldId + '/';
        }
        AbstractFormData.collectFieldDatasInContributions(field, breadthFirstMap, fieldPrefix);
        AbstractFormFieldData[] abstractFormFieldDataArray = field.getFields();
        int n = abstractFormFieldDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFormFieldData child = abstractFormFieldDataArray[n2];
            AbstractFormData.collectAllFieldsRec(child, breadthFirstMap, level + 1, fieldPrefix, false);
            ++n2;
        }
    }

    public AbstractFormFieldData findFieldByClass(Map<Integer, Map<String, AbstractFormFieldData>> breadthFirstMap, ClassIdentifier valueTypeIdentifier) {
        if (breadthFirstMap == null) {
            breadthFirstMap = this.getAllFieldsRec();
        }
        AbstractFormFieldData candidate = null;
        for (Map<String, AbstractFormFieldData> subMap : breadthFirstMap.values()) {
            for (Map.Entry<String, AbstractFormFieldData> entry : subMap.entrySet()) {
                AbstractFormFieldData fd = entry.getValue();
                String fieldId = entry.getKey();
                if (!this.matchesAllParts(valueTypeIdentifier, fieldId, fd)) continue;
                if (candidate != null) {
                    throw new ProcessingException("Found more than one field for class: [" + fd.getClass() + "]", new Object[0]);
                }
                candidate = fd;
            }
        }
        return candidate;
    }

    public Map<Integer, Map<String, AbstractPropertyData<?>>> getAllPropertiesRec() {
        TreeMap breadthFirstMap = new TreeMap();
        HashMap<String, AbstractPropertyData> rootMap = new HashMap<String, AbstractPropertyData>();
        breadthFirstMap.put(0, rootMap);
        Serializable[] serializableArray = this.getAllProperties();
        int n = serializableArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPropertyData prop = serializableArray[n2];
            rootMap.put(prop.getClass().getSimpleName(), prop);
            ++n2;
        }
        serializableArray = this.getFields();
        n = serializableArray.length;
        n2 = 0;
        while (n2 < n) {
            Serializable child = serializableArray[n2];
            this.collectAllPropertiesRec((AbstractFormFieldData)child, breadthFirstMap, 1, String.valueOf(((AbstractFormFieldData)child).getFieldId()) + '/');
            ++n2;
        }
        return breadthFirstMap;
    }

    private void collectAllPropertiesRec(AbstractFormFieldData field, Map<Integer, Map<String, AbstractPropertyData<?>>> breadthFirstMap, int level, String prefix) {
        Map subMap = breadthFirstMap.computeIfAbsent(level, k -> new HashMap());
        Serializable[] serializableArray = field.getAllProperties();
        int n = serializableArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPropertyData prop = serializableArray[n2];
            subMap.put(String.valueOf(prefix) + prop.getClass().getSimpleName(), prop);
            ++n2;
        }
        serializableArray = field.getFields();
        n = serializableArray.length;
        n2 = 0;
        while (n2 < n) {
            Serializable child = serializableArray[n2];
            this.collectAllPropertiesRec((AbstractFormFieldData)child, breadthFirstMap, level + 1, String.valueOf(prefix) + ((AbstractFormFieldData)child).getFieldId() + '/');
            ++n2;
        }
    }

    public AbstractPropertyData<?> findPropertyByClass(Map<Integer, Map<String, AbstractPropertyData<?>>> breadthFirstMap, ClassIdentifier valueTypeClassIdentifier) {
        if (breadthFirstMap == null) {
            breadthFirstMap = this.getAllPropertiesRec();
        }
        AbstractPropertyData<?> candidate = null;
        for (Map<String, AbstractPropertyData<?>> subMap : breadthFirstMap.values()) {
            for (Map.Entry<String, AbstractPropertyData<?>> entry : subMap.entrySet()) {
                AbstractPropertyData<?> pd;
                String propertyId = entry.getKey();
                if (!this.matchesAllParts(valueTypeClassIdentifier, propertyId, pd = entry.getValue())) continue;
                if (candidate != null) {
                    throw new ProcessingException("Found more than one property for class: [" + pd.getClass() + "]", new Object[0]);
                }
                candidate = pd;
            }
        }
        return candidate;
    }

    public AbstractFormData deepCopy() {
        try {
            return (AbstractFormData)CloneUtility.createDeepCopyBySerializing((Object)this);
        }
        catch (Exception e) {
            throw new ProcessingException("Could not create deep copy", new Object[]{e});
        }
    }

    private boolean matchesAllParts(ClassIdentifier valueTypeIdentifier, String fullyQualifiedFieldId, Object obj) {
        if (obj == null || obj.getClass() != valueTypeIdentifier.getLastSegment()) {
            return false;
        }
        Class[] classes = valueTypeIdentifier.getClasses();
        String[] fieldIdParts = fullyQualifiedFieldId.split("[/]");
        int i = classes.length - 2;
        int j = fieldIdParts.length - 2;
        while (i >= 0 && j >= 0) {
            String fieldId = classes[i].getName();
            int i1 = Math.max(fieldId.lastIndexOf(36), fieldId.lastIndexOf(46));
            if (fieldIdParts[j].equals(fieldId = fieldId.substring(i1 + 1))) {
                --i;
            }
            --j;
        }
        return i < 0;
    }

    public String toString() {
        return FormDataUtility.toString(this, false);
    }
}

