/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.form;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.reflect.FastBeanInfo;
import org.eclipse.scout.rt.platform.util.BeanUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.data.form.AbstractFormData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldBeanData;
import org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData;

public final class FormDataUtility {
    private static final Pattern FIELD_SUFFIX_PATTERN = Pattern.compile("Field$");
    private static final Pattern BUTTON_SUFFIX_PATTERN = Pattern.compile("Button$");
    private static final Pattern DATA_SUFFIX_PATTERN = Pattern.compile("Data$");
    private static final Comparator<AbstractPropertyData<?>> PROPERTY_DATA_COMPARATOR = (a, b) -> {
        String aid = null;
        String bid = null;
        if (a != null) {
            aid = a.getPropertyId();
        }
        if (b != null) {
            bid = b.getPropertyId();
        }
        return ObjectUtility.compareTo((Comparable)((Object)aid), (Comparable)((Object)bid));
    };
    private static final Comparator<AbstractFormFieldData> FORM_FIELD_DATA_COMPARATOR = (a, b) -> {
        String aid = null;
        String bid = null;
        if (a != null) {
            aid = a.getFieldId();
        }
        if (b != null) {
            bid = b.getFieldId();
        }
        return ObjectUtility.compareTo((Comparable)((Object)aid), (Comparable)((Object)bid));
    };

    private FormDataUtility() {
    }

    public static String getFieldDataId(String formFieldId) {
        String s = StringUtility.trim((String)formFieldId);
        if (StringUtility.isNullOrEmpty((CharSequence)s)) {
            return null;
        }
        if (s.endsWith("Field")) {
            return FIELD_SUFFIX_PATTERN.matcher(s).replaceAll("");
        }
        if (s.endsWith("Button")) {
            return BUTTON_SUFFIX_PATTERN.matcher(s).replaceAll("");
        }
        return s;
    }

    public static String getFieldDataId(AbstractFormFieldData fieldData) {
        String s = fieldData.getFieldId();
        if (s != null && s.endsWith("Data")) {
            s = DATA_SUFFIX_PATTERN.matcher(s).replaceAll("");
        }
        return FormDataUtility.getFieldDataId(s);
    }

    public static String toString(AbstractFormData formData, boolean includeEmptyData) {
        DataNode root = new DataNode();
        FormDataUtility.appendFormData(root, formData);
        DataNode n = root.firstChild();
        if (n != null && !includeEmptyData) {
            n.removeEmptyData();
        }
        return String.valueOf(n);
    }

    public static String toString(AbstractFormFieldData field, boolean includeEmptyData) {
        DataNode root = new DataNode();
        FormDataUtility.appendFieldData(root, field);
        DataNode n = root.firstChild();
        if (n != null && !includeEmptyData) {
            n.removeEmptyData();
        }
        return String.valueOf(n);
    }

    public static String toString(AbstractPropertyData<?> prop, boolean includeEmptyData) {
        DataNode root = new DataNode();
        FormDataUtility.appendPropertyData(root, prop);
        DataNode n = root.firstChild();
        if (n != null && !includeEmptyData) {
            n.removeEmptyData();
        }
        return String.valueOf(n);
    }

    private static void appendFormData(DataNode parent, AbstractFormData formData) {
        if (formData == null) {
            return;
        }
        DataNode n = parent.addChild();
        n.prefix = String.valueOf(formData.getClass().getSimpleName()) + "[";
        n.suffix = "]";
        FormDataUtility.appendPropertyDatas(n, formData.getAllProperties());
        FormDataUtility.appendFieldDatas(n, formData.getFields());
    }

    private static void appendFieldDatas(DataNode parent, AbstractFormFieldData[] fields) {
        if (fields == null || fields.length == 0) {
            return;
        }
        Arrays.sort(fields, FORM_FIELD_DATA_COMPARATOR);
        AbstractFormFieldData[] abstractFormFieldDataArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFormFieldData field = abstractFormFieldDataArray[n2];
            FormDataUtility.appendFieldData(parent, field);
            ++n2;
        }
    }

    private static void appendFieldData(DataNode parent, AbstractFormFieldData field) {
        if (field == null) {
            return;
        }
        DataNode n = parent.addChild();
        if (field instanceof AbstractValueFieldData) {
            AbstractValueFieldData valueField = (AbstractValueFieldData)field;
            n.prefix = String.valueOf(field.getClass().getSimpleName()) + ": " + FormDataUtility.toLogText(valueField.getValue());
            if (!valueField.isValueSet()) {
                n.prefix = String.valueOf(n.prefix) + " (valueSet=false)";
            }
            n.hasContent = valueField.getValue() != null;
        } else if (field instanceof AbstractTableFieldBeanData) {
            AbstractTableFieldBeanData tableData = (AbstractTableFieldBeanData)field;
            FastBeanInfo fastBeanInfo = BeanUtility.getFastBeanInfo(tableData.getRowType(), AbstractTableFieldBeanData.class);
            int rows = tableData.getRowCount();
            int cols = fastBeanInfo.getPropertyDescriptors().length;
            n.prefix = String.valueOf(field.getClass().getSimpleName()) + ": " + rows + " rows, " + cols + " cols [";
            if (!tableData.isValueSet()) {
                n.prefix = String.valueOf(n.prefix) + " (valueSet=false)";
            }
            n.suffix = "]";
        } else {
            n.prefix = field.getClass().getSimpleName();
            n.hasContent = field.isValueSet();
        }
        FormDataUtility.appendPropertyDatas(n, field.getAllProperties());
        FormDataUtility.appendFieldDatas(n, field.getFields());
    }

    private static void appendPropertyDatas(DataNode parent, AbstractPropertyData<?>[] properties) {
        if (properties == null || properties.length == 0) {
            return;
        }
        Arrays.sort(properties, PROPERTY_DATA_COMPARATOR);
        AbstractPropertyData<?>[] abstractPropertyDataArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPropertyData<?> prop = abstractPropertyDataArray[n2];
            FormDataUtility.appendPropertyData(parent, prop);
            ++n2;
        }
    }

    private static void appendPropertyData(DataNode parent, AbstractPropertyData<?> prop) {
        if (prop == null) {
            return;
        }
        DataNode n = parent.addChild();
        n.prefix = String.valueOf(prop.getClass().getSimpleName()) + ": " + FormDataUtility.toLogText(prop.getValue());
        if (!prop.isValueSet()) {
            n.prefix = String.valueOf(n.prefix) + " (valueSet=false)";
        }
        n.hasContent = prop.getValue() != null;
    }

    private static String toLogText(Object o) {
        if (o == null) {
            return "null";
        }
        if (o.getClass().isArray()) {
            int n = Array.getLength(o);
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            int i = 0;
            while (i < n) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(FormDataUtility.toLogText(Array.get(o, i)));
                ++i;
            }
            sb.append("]");
            return sb.toString();
        }
        return o.toString();
    }

    private static void indent(StringBuilder sb, int level) {
        int i = 0;
        while (i < level) {
            sb.append("  ");
            ++i;
        }
    }

    private static final class DataNode {
        public String prefix;
        public String suffix;
        public boolean hasContent;
        private final List<DataNode> m_children = new ArrayList<DataNode>();

        private DataNode() {
        }

        public DataNode addChild() {
            DataNode n = new DataNode();
            this.m_children.add(n);
            return n;
        }

        public DataNode firstChild() {
            return this.m_children.isEmpty() ? null : this.m_children.get(0);
        }

        public void removeEmptyData() {
            Iterator<DataNode> it = this.m_children.iterator();
            while (it.hasNext()) {
                DataNode c = it.next();
                c.removeEmptyData();
                if (c.hasContent || !c.m_children.isEmpty()) continue;
                it.remove();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.buildRec(sb, 0);
            return sb.toString();
        }

        private void buildRec(StringBuilder sb, int level) {
            if (this.prefix != null) {
                sb.append(this.prefix);
            }
            if (!this.m_children.isEmpty()) {
                for (DataNode c : this.m_children) {
                    sb.append("\n");
                    FormDataUtility.indent(sb, level + 1);
                    c.buildRec(sb, level + 1);
                }
                if (this.suffix != null) {
                    sb.append("\n");
                    FormDataUtility.indent(sb, level);
                }
            }
            if (this.suffix != null) {
                sb.append(this.suffix);
            }
        }
    }
}

