/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.form.fields;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.platform.Replace;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.shared.data.form.FormDataUtility;
import org.eclipse.scout.rt.shared.data.form.IPropertyHolder;
import org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData;
import org.eclipse.scout.rt.shared.extension.AbstractContributionComposite;

public abstract class AbstractFormFieldData
extends AbstractContributionComposite
implements IPropertyHolder {
    private static final long serialVersionUID = 1L;
    private Map<Class<?>, Class<? extends AbstractFormFieldData>> m_fieldDataReplacements;
    private Map<Class<? extends AbstractPropertyData>, AbstractPropertyData> m_propertyMap;
    private Map<Class<? extends AbstractFormFieldData>, AbstractFormFieldData> m_fieldMap;
    private boolean m_valueSet;

    private List<Class<AbstractPropertyData>> getConfiguredPropertyDatas() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, AbstractPropertyData.class);
    }

    private List<Class<? extends AbstractFormFieldData>> getConfiguredFieldDatas() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fca = ConfigurationUtility.filterClasses((Class[])dca, AbstractFormFieldData.class);
        return ConfigurationUtility.removeReplacedClasses((List)fca);
    }

    public Class<?> getFieldStopClass() {
        return AbstractFormFieldData.class;
    }

    @Override
    protected void initConfig() {
        List<Class<AbstractPropertyData>> configuredPropertyDatas = this.getConfiguredPropertyDatas();
        HashMap<Class<? extends AbstractPropertyData>, AbstractPropertyData> propMap = new HashMap<Class<? extends AbstractPropertyData>, AbstractPropertyData>(configuredPropertyDatas.size());
        for (Class<AbstractPropertyData> propertyDataClazz : configuredPropertyDatas) {
            AbstractPropertyData p = (AbstractPropertyData)ConfigurationUtility.newInnerInstance((Object)this, propertyDataClazz);
            propMap.put(p.getClass(), p);
        }
        List<Class<? extends AbstractFormFieldData>> fieldDataClasses = this.getConfiguredFieldDatas();
        HashMap<Class<? extends AbstractFormFieldData>, AbstractFormFieldData> map = new HashMap<Class<? extends AbstractFormFieldData>, AbstractFormFieldData>(fieldDataClasses.size());
        for (Class<? extends AbstractFormFieldData> formFieldDataClazz : fieldDataClasses) {
            AbstractFormFieldData f = (AbstractFormFieldData)ConfigurationUtility.newInnerInstance((Object)this, formFieldDataClazz);
            map.put(f.getClass(), f);
        }
        if (!propMap.isEmpty()) {
            this.m_propertyMap = propMap;
        }
        if (!map.isEmpty()) {
            this.m_fieldMap = map;
            Map replacements = ConfigurationUtility.getReplacementMapping(fieldDataClasses);
            if (!replacements.isEmpty()) {
                this.m_fieldDataReplacements = replacements;
            }
        }
    }

    public String getFieldId() {
        Class<?> c = this.getClass();
        while (c.isAnnotationPresent(Replace.class)) {
            c = c.getSuperclass();
        }
        String s = c.getName();
        int i = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
        s = s.substring(i + 1);
        return s;
    }

    public boolean isValueSet() {
        return this.m_valueSet;
    }

    public void setValueSet(boolean b) {
        this.m_valueSet = b;
    }

    @Override
    public AbstractPropertyData getPropertyById(String id) {
        if (this.m_propertyMap == null) {
            return null;
        }
        for (AbstractPropertyData p : this.m_propertyMap.values()) {
            if (!p.getPropertyId().equalsIgnoreCase(id)) continue;
            return p;
        }
        return null;
    }

    @Override
    public <T extends AbstractPropertyData> T getPropertyByClass(Class<T> c) {
        if (this.m_propertyMap == null) {
            return null;
        }
        return (T)this.m_propertyMap.get(c);
    }

    @Override
    public <T extends AbstractPropertyData> void setPropertyByClass(Class<T> c, T v) {
        if (v == null) {
            if (this.m_propertyMap != null) {
                this.m_propertyMap.remove(c);
            }
        } else {
            if (this.m_propertyMap == null) {
                this.m_propertyMap = new HashMap<Class<? extends AbstractPropertyData>, AbstractPropertyData>();
            }
            this.m_propertyMap.put(c, v);
        }
    }

    @Override
    public AbstractPropertyData[] getAllProperties() {
        return this.m_propertyMap != null ? this.m_propertyMap.values().toArray(new AbstractPropertyData[0]) : new AbstractPropertyData[]{};
    }

    public AbstractFormFieldData getFieldById(String id) {
        if (this.m_fieldMap == null) {
            return null;
        }
        String fieldDataId = FormDataUtility.getFieldDataId(id);
        for (AbstractFormFieldData f : this.m_fieldMap.values()) {
            if (!f.getFieldId().equals(fieldDataId)) continue;
            return f;
        }
        return null;
    }

    public <T extends AbstractFormFieldData> T getFieldByClass(Class<T> c) {
        if (this.m_fieldMap == null) {
            return null;
        }
        Class<T> clazz = this.getReplacingFieldDataClass(c);
        return (T)this.m_fieldMap.get(clazz);
    }

    public <T extends AbstractFormFieldData> void setFieldByClass(Class<T> c, T v) {
        Class<T> clazz = this.getReplacingFieldDataClass(c);
        if (v == null) {
            if (this.m_fieldMap != null) {
                this.m_fieldMap.remove(clazz);
            }
        } else {
            if (this.m_fieldMap == null) {
                this.m_fieldMap = new HashMap<Class<? extends AbstractFormFieldData>, AbstractFormFieldData>();
            }
            this.m_fieldMap.put(clazz, v);
        }
    }

    private <T> Class<? extends T> getReplacingFieldDataClass(Class<T> c) {
        Class<? extends AbstractFormFieldData> replacingFieldClass;
        if (this.m_fieldDataReplacements != null && (replacingFieldClass = this.m_fieldDataReplacements.get(c)) != null) {
            return replacingFieldClass;
        }
        return c;
    }

    public AbstractFormFieldData[] getFields() {
        if (this.m_fieldMap == null) {
            return new AbstractFormFieldData[0];
        }
        return this.m_fieldMap.values().toArray(new AbstractFormFieldData[0]);
    }

    public String toString() {
        return FormDataUtility.toString(this, false);
    }
}

