/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension;

import java.io.Serializable;
import java.util.List;
import org.eclipse.scout.rt.shared.extension.ExtensionRegistryItem;
import org.eclipse.scout.rt.shared.extension.ExtensionScope;
import org.eclipse.scout.rt.shared.extension.ExtensionStack;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ScopeStack;

public class ExtensionContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ExtensionScope<ExtensionRegistryItem> m_contributionScope;
    private final ExtensionScope<ExtensionRegistryItem> m_extensionScope;
    private final List<List<? extends IExtension<?>>> m_extensionStack;

    public ExtensionContext(ScopeStack scopeStack, ExtensionStack extensionStack) {
        this.m_contributionScope = scopeStack.getContributionScope();
        this.m_extensionScope = scopeStack.getExtensionScope();
        this.m_extensionStack = extensionStack.snapshot();
    }

    public ScopeStack getScopeStack() {
        return new BackupScopeStack(this.m_contributionScope, this.m_extensionScope);
    }

    public ExtensionStack getExtensionStack() {
        return new ExtensionStack(this.m_extensionStack);
    }

    public static class BackupScopeStack
    extends ScopeStack {
        public BackupScopeStack(ExtensionScope<ExtensionRegistryItem> globalContributionScope, ExtensionScope<ExtensionRegistryItem> globalExtensionScope) {
            super(globalContributionScope, globalExtensionScope);
        }

        @Override
        public void popScope() {
            if (super.isEmpty()) {
                throw new IllegalStateException("popScope from empty backup scope stack");
            }
            super.popScope();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }
}

