/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.scout.rt.platform.classid.ClassIdentifier;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.extension.AbstractExtensionRegistryItem;
import org.eclipse.scout.rt.shared.extension.ScopeItem;

public class ExtensionScope<T extends AbstractExtensionRegistryItem> {
    private final ExtensionScope<T> m_parentScope;
    private final Map<Class<?>, Set<ScopeItem>> m_scopeItems;
    private final Map<ClassIdentifier, List<T>> m_extensionItems;

    public ExtensionScope(Map<ClassIdentifier, List<T>> extensionItems, boolean topDownStrategy) {
        this.m_extensionItems = extensionItems;
        this.m_scopeItems = this.createGlobalScope(extensionItems.keySet(), topDownStrategy);
        this.m_parentScope = null;
    }

    protected ExtensionScope(Map<Class<?>, Set<ScopeItem>> scopeItems, ExtensionScope<T> parentScope, Map<ClassIdentifier, List<T>> extensionItems) {
        this.m_scopeItems = scopeItems;
        this.m_parentScope = parentScope;
        this.m_extensionItems = extensionItems;
    }

    protected Map<Class<?>, Set<ScopeItem>> createGlobalScope(Collection<ClassIdentifier> classIdentifiers, boolean topDownStrategy) {
        HashMap scopeItems = new HashMap(classIdentifiers.size());
        for (ClassIdentifier identifier : classIdentifiers) {
            ScopeItem item = new ScopeItem(identifier, topDownStrategy);
            this.addCurrentItemSegment(scopeItems, item);
        }
        return scopeItems;
    }

    public Set<T> getRegistryItems(Class<?> owner) {
        Set<ScopeItem> scopeItems = this.getScopeItems(owner);
        return this.resolveRegistryItems(scopeItems);
    }

    public ExtensionScope<T> createSubScope(Class<?> ownerType) {
        if (ownerType == null) {
            throw new IllegalArgumentException("ownerType must not be null.");
        }
        HashSet<ScopeItem> items = new HashSet<ScopeItem>();
        ExtensionScope<T> curScope = this;
        while (curScope != null) {
            this.collectScopeItemsRec(ownerType, items, curScope.m_scopeItems);
            curScope = curScope.m_parentScope;
        }
        if (CollectionUtility.isEmpty(items)) {
            return null;
        }
        HashMap subScopeItems = new HashMap(items.size());
        for (ScopeItem item : items) {
            this.collectSubScopeItems(item, subScopeItems);
        }
        if (subScopeItems.isEmpty()) {
            return null;
        }
        return new ExtensionScope<T>(subScopeItems, this, this.m_extensionItems);
    }

    public Set<ScopeItem> filterScopeItems(Class<?> modelClass, Iterator<?> parentModelObjectIterator) {
        Set<ScopeItem> potentialScopeItems = this.getScopeItems(modelClass);
        if (CollectionUtility.isEmpty(potentialScopeItems)) {
            return null;
        }
        HashSet<ScopeItem> filteredScopeItems = new HashSet<ScopeItem>();
        HashMap subScopeItems = new HashMap(potentialScopeItems.size());
        this.collectFilteredandSubScopItems(potentialScopeItems, filteredScopeItems, subScopeItems);
        if (parentModelObjectIterator != null && CollectionUtility.hasElements(potentialScopeItems)) {
            while (parentModelObjectIterator.hasNext()) {
                Object parent = parentModelObjectIterator.next();
                if (parent == null) continue;
                potentialScopeItems.clear();
                this.collectScopeItemsRec(parent.getClass(), potentialScopeItems, subScopeItems);
                this.collectFilteredandSubScopItems(potentialScopeItems, filteredScopeItems, subScopeItems);
            }
        }
        return filteredScopeItems;
    }

    protected void collectFilteredandSubScopItems(Set<ScopeItem> potentialScopeItems, Set<ScopeItem> filteredScopeItems, Map<Class<?>, Set<ScopeItem>> subScopeItems) {
        for (ScopeItem item : potentialScopeItems) {
            if (item.isLastSegment()) {
                filteredScopeItems.add(item);
                continue;
            }
            this.collectSubScopeItems(item, subScopeItems);
        }
    }

    protected void collectSubScopeItems(ScopeItem item, Map<Class<?>, Set<ScopeItem>> subScopeItems) {
        ScopeItem subScopeItem = item.createSubScopeItem();
        if (subScopeItem == null) {
            return;
        }
        this.addCurrentItemSegment(subScopeItems, subScopeItem);
    }

    protected void addCurrentItemSegment(Map<Class<?>, Set<ScopeItem>> scopeItems, ScopeItem item) {
        Class<?> currentSegment = item.getCurrentSegment();
        Set subItemList = scopeItems.computeIfAbsent(currentSegment, k -> new HashSet());
        subItemList.add(item);
    }

    protected Set<ScopeItem> getScopeItems(Class<?> owner) {
        HashSet<ScopeItem> collector = new HashSet<ScopeItem>();
        if (this.m_parentScope != null) {
            Set<ScopeItem> parentScopeItems = this.m_parentScope.getScopeItems(owner);
            collector.addAll(parentScopeItems);
        }
        this.collectScopeItemsRec(owner, collector, this.m_scopeItems);
        return collector;
    }

    protected void collectScopeItemsRec(Class<?> curClass, Set<ScopeItem> collector, Map<Class<?>, Set<ScopeItem>> scopeItems) {
        Class<?> superclass;
        if (Object.class.equals(curClass)) {
            return;
        }
        Set<ScopeItem> list = scopeItems.get(curClass);
        if (CollectionUtility.hasElements(list)) {
            collector.addAll(list);
        }
        if ((superclass = curClass.getSuperclass()) != null) {
            this.collectScopeItemsRec(superclass, collector, scopeItems);
        }
        Class<?>[] classArray = curClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> ifc = classArray[n2];
            this.collectScopeItemsRec(ifc, collector, scopeItems);
            ++n2;
        }
    }

    public Set<T> resolveRegistryItems(Set<ScopeItem> scopeItems) {
        if (CollectionUtility.isEmpty(scopeItems)) {
            return Collections.emptySet();
        }
        TreeSet<AbstractExtensionRegistryItem> collector = new TreeSet<AbstractExtensionRegistryItem>(new P_ExtensionRegistryItemComparator());
        for (ScopeItem scopeItem : scopeItems) {
            List<T> localExtensions;
            ClassIdentifier classIdentifier = scopeItem.getIdentifier();
            if (!scopeItem.isLastSegment() || !CollectionUtility.hasElements(localExtensions = this.m_extensionItems.get(classIdentifier))) continue;
            collector.addAll(localExtensions);
        }
        return collector;
    }

    private static class P_ExtensionRegistryItemComparator
    implements Comparator<AbstractExtensionRegistryItem>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private P_ExtensionRegistryItemComparator() {
        }

        @Override
        public int compare(AbstractExtensionRegistryItem o1, AbstractExtensionRegistryItem o2) {
            return Long.compare(o1.getOrder(), o2.getOrder());
        }
    }
}

