/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http;

import java.util.Date;
import java.util.List;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.shared.http.AbstractMultiSessionCookieStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheMultiSessionCookieStore
extends AbstractMultiSessionCookieStore<CookieStore>
implements CookieStore {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheMultiSessionCookieStore.class);

    @Override
    protected CookieStore createDefaultCookieStore() {
        CookieStore cookieStore = this.createNewCookieStore();
        return new P_DefaultCookieStoreDecorator(cookieStore);
    }

    @Override
    protected CookieStore createNewCookieStore() {
        return new BasicCookieStore();
    }

    public void addCookie(Cookie cookie) {
        ((CookieStore)this.getDelegate()).addCookie(cookie);
    }

    public List<Cookie> getCookies() {
        return ((CookieStore)this.getDelegate()).getCookies();
    }

    public boolean clearExpired(Date date) {
        return ((CookieStore)this.getDelegate()).clearExpired(date);
    }

    public void clear() {
        ((CookieStore)this.getDelegate()).clear();
    }

    private static class P_DefaultCookieStoreDecorator
    implements CookieStore {
        private final CookieStore m_cookieStore;

        public P_DefaultCookieStoreDecorator(CookieStore cookieStore) {
            this.m_cookieStore = cookieStore;
        }

        public void addCookie(Cookie cookie) {
            Assertions.assertNotNull((Object)cookie);
            Exception e = null;
            if (LOG.isDebugEnabled()) {
                e = new Exception("stack trace for debugging");
            }
            LOG.warn("adding cookie to default cookie store which could be used by other users too [cookie: {}]", (Object)cookie, (Object)e);
            this.m_cookieStore.addCookie(cookie);
        }

        public List<Cookie> getCookies() {
            return this.m_cookieStore.getCookies();
        }

        public void clear() {
            this.m_cookieStore.clear();
        }

        public boolean clearExpired(Date date) {
            return this.m_cookieStore.clearExpired(date);
        }
    }
}

