/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http;

import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import java.io.IOException;
import org.eclipse.scout.rt.shared.http.AbstractHttpTransportManager;

public class BasicAuthHttpTransportManager
extends AbstractHttpTransportManager {
    private String m_user;
    private String m_password;

    public BasicAuthHttpTransportManager withUser(String user) {
        this.m_user = user;
        return this;
    }

    public BasicAuthHttpTransportManager withPassword(String password) {
        this.m_password = password;
        return this;
    }

    @Override
    protected HttpRequestInitializer createHttpRequestInitializer() {
        return new BasicAuthRequestInitializer(this.m_user, this.m_password);
    }

    public static class BasicAuthRequestInitializer
    extends AbstractHttpTransportManager.DefaultHttpRequestInitializer
    implements HttpExecuteInterceptor {
        private String m_user;
        private String m_password;

        public BasicAuthRequestInitializer(String user, String password) {
            this.m_user = user;
            this.m_password = password;
        }

        @Override
        public void initialize(HttpRequest request) throws IOException {
            super.initialize(request);
            request.setInterceptor((HttpExecuteInterceptor)this);
        }

        public void intercept(HttpRequest request) {
            request.getHeaders().setBasicAuthentication(this.m_user, this.m_password);
        }
    }
}

