/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http.retry;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;

public class OneTimeRepeatableRequestEntityProxy
implements HttpEntity {
    private final HttpEntity m_original;
    private boolean m_consumed;

    public static void installRetry(HttpRequest request) {
        HttpEntity entity;
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null && !(entity instanceof OneTimeRepeatableRequestEntityProxy)) {
            ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new OneTimeRepeatableRequestEntityProxy(entity));
        }
    }

    public OneTimeRepeatableRequestEntityProxy(HttpEntity original) {
        this.m_original = original;
    }

    public HttpEntity getOriginal() {
        return this.m_original;
    }

    public boolean isRepeatable() {
        return !this.m_consumed;
    }

    public boolean isChunked() {
        return this.m_original.isChunked();
    }

    public long getContentLength() {
        return this.m_original.getContentLength();
    }

    public Header getContentType() {
        return this.m_original.getContentType();
    }

    public Header getContentEncoding() {
        return this.m_original.getContentEncoding();
    }

    public InputStream getContent() throws IOException {
        return this.m_original.getContent();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        this.m_consumed = true;
        this.m_original.writeTo(outstream);
    }

    public boolean isStreaming() {
        return this.m_original.isStreaming();
    }

    public void consumeContent() throws IOException {
        this.m_consumed = true;
        this.m_original.consumeContent();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.m_original + '}';
    }
}

