/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http.transport;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.util.StreamingContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.shared.http.transport.ApacheHttpResponse;

public class ApacheHttpRequest
extends LowLevelHttpRequest {
    private final HttpClient m_httpClient;
    private final HttpRequestBase m_request;

    public ApacheHttpRequest(HttpClient httpClient, HttpRequestBase request) {
        this.m_httpClient = httpClient;
        this.m_request = request;
    }

    public void addHeader(String name, String value) throws IOException {
        this.m_request.addHeader(name, value);
    }

    public void setTimeout(int connectTimeout, int readTimeout) throws IOException {
        super.setTimeout(connectTimeout, readTimeout);
        RequestConfig config = this.m_request.getConfig();
        RequestConfig.Builder configBuilder = config != null ? RequestConfig.copy((RequestConfig)config) : RequestConfig.custom();
        configBuilder.setConnectTimeout(connectTimeout);
        configBuilder.setSocketTimeout(readTimeout);
        this.m_request.setConfig(configBuilder.build());
    }

    public LowLevelHttpResponse execute() throws IOException {
        final StreamingContent streamingContent = this.getStreamingContent();
        if (streamingContent != null) {
            if (!(this.m_request instanceof HttpEntityEnclosingRequest)) {
                throw new ProcessingException("This request {} does not support content.", new Object[]{this.m_request});
            }
            AbstractHttpEntity entity = new AbstractHttpEntity(){

                public void writeTo(OutputStream outstream) throws IOException {
                    streamingContent.writeTo(outstream);
                }

                public boolean isStreaming() {
                    return true;
                }

                public boolean isRepeatable() {
                    if (streamingContent instanceof HttpContent) {
                        return ((HttpContent)streamingContent).retrySupported();
                    }
                    return false;
                }

                public long getContentLength() {
                    return ApacheHttpRequest.this.getContentLength();
                }

                public InputStream getContent() {
                    throw new UnsupportedOperationException("Streaming entity cannot be represented as an input stream.");
                }
            };
            ((HttpEntityEnclosingRequest)this.m_request).setEntity((HttpEntity)entity);
            entity.setContentEncoding(this.getContentEncoding());
            entity.setContentType(this.getContentType());
        }
        return this.createResponseInternal();
    }

    protected ApacheHttpResponse createResponseInternal() throws IOException {
        return new ApacheHttpResponse(this.m_request, this.m_httpClient.execute((HttpUriRequest)this.m_request));
    }
}

