/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http.transport;

import com.google.api.client.http.LowLevelHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class ApacheHttpResponse
extends LowLevelHttpResponse {
    private final HttpRequestBase m_request;
    private final HttpResponse m_response;

    public ApacheHttpResponse(HttpRequestBase request, HttpResponse response) {
        this.m_request = request;
        this.m_response = response;
    }

    public InputStream getContent() throws IOException {
        HttpEntity entity = this.m_response.getEntity();
        return entity != null ? entity.getContent() : null;
    }

    public String getContentEncoding() throws IOException {
        HttpEntity entity = this.m_response.getEntity();
        Header contentEncoding = entity != null ? entity.getContentEncoding() : null;
        return contentEncoding != null ? contentEncoding.getValue() : null;
    }

    public long getContentLength() throws IOException {
        HttpEntity entity = this.m_response.getEntity();
        return entity != null ? entity.getContentLength() : 0L;
    }

    public String getContentType() throws IOException {
        HttpEntity entity = this.m_response.getEntity();
        Header contentType = entity != null ? entity.getContentType() : null;
        return contentType != null ? contentType.getValue() : null;
    }

    public String getStatusLine() throws IOException {
        return this.m_response.getStatusLine().toString();
    }

    public int getStatusCode() throws IOException {
        return this.m_response.getStatusLine().getStatusCode();
    }

    public String getReasonPhrase() throws IOException {
        return this.m_response.getStatusLine().getReasonPhrase();
    }

    public int getHeaderCount() throws IOException {
        return this.m_response.getAllHeaders().length;
    }

    public String getHeaderName(int index) throws IOException {
        return this.m_response.getAllHeaders()[index].getName();
    }

    public String getHeaderValue(int index) throws IOException {
        return this.m_response.getAllHeaders()[index].getValue();
    }

    public void disconnect() throws IOException {
        this.m_request.abort();
    }
}

