/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.calendar;

import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.XmlUtility;
import org.eclipse.scout.rt.shared.services.common.calendar.HolidayItem;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class HolidayCalendarItemParser {
    private static final Logger LOG = LoggerFactory.getLogger(HolidayCalendarItemParser.class);
    private static final String HOLIDAY = "holiday";
    private static final String DATE = "date";
    private static final String WEEKDAY = "weekday";
    private static final String INSTANCE = "instance";
    private static final String TEXT = "text";
    private static final String TOOLTIP = "tooltip";
    private static final String ID = "id";
    private static final String RELATIVE_TO = "relativeTo";
    private final SimpleDateFormat m_dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private final Element m_xml;

    public HolidayCalendarItemParser(URL xmlResource) {
        this.m_xml = XmlUtility.getXmlDocument((URL)xmlResource).getDocumentElement();
    }

    public HolidayCalendarItemParser(InputStream xmlResource, String displayFileName) {
        this.m_xml = XmlUtility.getXmlDocument((InputStream)xmlResource).getDocumentElement();
    }

    public Set<? extends ICalendarItem> getItems(Locale loc, Date minDate, Date maxDate) {
        HashSet<HolidayItem> itemList = new HashSet<HolidayItem>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(minDate);
        int startYear = cal.get(1);
        cal.setTime(maxDate);
        int endYear = cal.get(1);
        int year = startYear;
        while (year <= endYear) {
            this.addHolidays(loc, year, itemList);
            ++year;
        }
        itemList.removeIf(item -> minDate.after(item.getStart()) || maxDate.before(item.getStart()));
        return itemList;
    }

    private void addHolidays(Locale loc, int year, Collection<HolidayItem> newList) {
        HashMap<String, HolidayItem> holidayMap = new HashMap<String, HolidayItem>();
        String[] locPatterns = new String[]{String.valueOf(loc.getCountry()) + "_" + loc.getLanguage() + "_" + loc.getVariant(), String.valueOf(loc.getCountry()) + "_" + loc.getLanguage(), loc.getLanguage()};
        long index = 1L;
        for (Element holidayElem : XmlUtility.getChildElements((Element)this.m_xml, (String)HOLIDAY)) {
            try {
                Date d = this.evaluateHolidayDate(holidayElem, holidayMap, year);
                if (d == null) continue;
                String text = this.getAttributeByLocale(holidayElem, locPatterns, TEXT);
                String tooltip = this.getAttributeByLocale(holidayElem, locPatterns, TOOLTIP);
                String itemId = null;
                if (holidayElem.hasAttribute(ID)) {
                    itemId = holidayElem.getAttribute(ID);
                }
                if (itemId == null) {
                    itemId = "" + index;
                }
                HolidayItem item = new HolidayItem();
                item.setStart(d);
                item.setSubject(text);
                item.setBody(tooltip);
                ++index;
                holidayMap.put(itemId, item);
            }
            catch (Exception e) {
                LOG.warn("Could not parse item '{}'", (Object)holidayElem, (Object)e);
            }
        }
        newList.addAll(holidayMap.values());
    }

    private Date evaluateHolidayDate(Element holidayElem, Map<String, HolidayItem> holidayMap, int year) throws ParseException {
        HolidayItem relItem;
        String datePattern = null;
        if (holidayElem.hasAttribute(DATE)) {
            datePattern = holidayElem.getAttribute(DATE);
        }
        String weekdayPattern = null;
        if (holidayElem.hasAttribute(WEEKDAY)) {
            weekdayPattern = holidayElem.getAttribute(WEEKDAY);
        }
        String instancePattern = null;
        if (holidayElem.hasAttribute(INSTANCE)) {
            instancePattern = holidayElem.getAttribute(INSTANCE);
        }
        String relativeToId = null;
        if (holidayElem.hasAttribute(RELATIVE_TO)) {
            relativeToId = holidayElem.getAttribute(RELATIVE_TO);
        }
        int weekday = -1;
        if (weekdayPattern != null) {
            if ("MONDAY".equalsIgnoreCase(weekdayPattern)) {
                weekday = 2;
            } else if ("TUESDAY".equalsIgnoreCase(weekdayPattern)) {
                weekday = 3;
            } else if ("WEDNESDAY".equalsIgnoreCase(weekdayPattern)) {
                weekday = 4;
            } else if ("THURSDAY".equalsIgnoreCase(weekdayPattern)) {
                weekday = 5;
            } else if ("FRIDAY".equalsIgnoreCase(weekdayPattern)) {
                weekday = 6;
            } else if ("SATURDAY".equalsIgnoreCase(weekdayPattern)) {
                weekday = 7;
            } else if ("SUNDAY".equalsIgnoreCase(weekdayPattern)) {
                weekday = 1;
            }
        }
        int instance = 0;
        if (instancePattern != null) {
            if ("FIRST".equalsIgnoreCase(instancePattern)) {
                instance = 1;
            } else if ("LAST".equalsIgnoreCase(instancePattern)) {
                instance = -1;
            } else if (StringUtility.hasText((CharSequence)instancePattern)) {
                instance = Integer.parseInt(instancePattern);
            }
        }
        Date startDate = null;
        if (relativeToId != null && (relItem = holidayMap.get(relativeToId)) != null) {
            startDate = relItem.getStart();
        }
        if (startDate == null) {
            if (datePattern == null) {
                return null;
            }
            if (datePattern.endsWith("0000")) {
                startDate = this.m_dateFormat.parse(String.valueOf(datePattern.substring(0, datePattern.length() - 4)) + year);
            } else if (datePattern.endsWith("" + year)) {
                startDate = this.m_dateFormat.parse(datePattern);
            } else {
                return null;
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        if (weekday >= 0 && instance != 0) {
            if (instance > 0) {
                int n = instance;
                while (n > 0) {
                    if (cal.get(7) != weekday || --n != 0) {
                        cal.add(5, 1);
                        continue;
                    }
                    break;
                }
            } else {
                int n = -instance;
                while (n > 0) {
                    if (cal.get(7) != weekday || --n != 0) {
                        cal.add(5, -1);
                        continue;
                    }
                    break;
                }
            }
        }
        startDate = cal.getTime();
        return startDate;
    }

    private String getAttributeByLocale(Element e, String[] locPatterns, String attributeNamePrefix) {
        String[] stringArray = locPatterns;
        int n = locPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String s;
            String locPattern = stringArray[n2];
            String attribName = String.valueOf(attributeNamePrefix) + "_" + locPattern;
            if (e.hasAttribute(attribName) && (s = e.getAttribute(attribName)) != null) {
                return s;
            }
            ++n2;
        }
        return null;
    }
}

