/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeService;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;

public final class CODES {
    private CODES() {
    }

    public static <T> ICodeType<T, ?> findCodeTypeById(T id) {
        return ((ICodeService)BEANS.get(ICodeService.class)).findCodeTypeById(id);
    }

    public static List<ICodeType<?, ?>> getCodeTypes(Class<?> ... types) {
        List<Class<? extends ICodeType<?, ?>>> typeList = CODES.varargToList(types);
        return ((ICodeService)BEANS.get(ICodeService.class)).getCodeTypes(typeList);
    }

    public static List<ICodeType<?, ?>> getCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) {
        return ((ICodeService)BEANS.get(ICodeService.class)).getCodeTypes(types);
    }

    public static <CODE extends ICode<?>> CODE getCode(Class<CODE> type) {
        return ((ICodeService)BEANS.get(ICodeService.class)).getCode(type);
    }

    public static <T extends ICodeType> T reloadCodeType(Class<T> type) {
        return ((ICodeService)BEANS.get(ICodeService.class)).reloadCodeType(type);
    }

    public static List<ICodeType<?, ?>> reloadCodeTypes(Class<?> ... types) {
        List<Class<? extends ICodeType<?, ?>>> typeList = CODES.varargToList(types);
        return ((ICodeService)BEANS.get(ICodeService.class)).reloadCodeTypes(typeList);
    }

    public static List<ICodeType<?, ?>> reloadCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) {
        return ((ICodeService)BEANS.get(ICodeService.class)).reloadCodeTypes(types);
    }

    public static void invalidateCodeType(Class<? extends ICodeType> type) {
        ((ICodeService)BEANS.get(ICodeService.class)).invalidateCodeType(type);
    }

    public static void invalidateCodeTypes(Class<?> ... types) {
        List<Class<? extends ICodeType<?, ?>>> typeList = CODES.varargToList(types);
        ((ICodeService)BEANS.get(ICodeService.class)).invalidateCodeTypes(typeList);
    }

    public static void invalidateCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) {
        ((ICodeService)BEANS.get(ICodeService.class)).invalidateCodeTypes(types);
    }

    private static List<Class<? extends ICodeType<?, ?>>> varargToList(Class<?> ... types) {
        if (types == null) {
            return CollectionUtility.emptyArrayList();
        }
        ArrayList typeList = new ArrayList(types.length);
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> t = classArray[n2];
            if (ICodeType.class.isAssignableFrom(t)) {
                typeList.add(t);
            }
            ++n2;
        }
        return typeList;
    }

    public static Collection<ICodeType<?, ?>> getAllCodeTypes(String classPrefix) {
        Set<Class<? extends ICodeType<?, ?>>> allCodeTypeClasses = CODES.getAllCodeTypeClasses(classPrefix);
        ArrayList list = CollectionUtility.arrayList(allCodeTypeClasses);
        return CODES.getCodeTypes(list);
    }

    public static Set<Class<? extends ICodeType<?, ?>>> getAllCodeTypeClasses(String classPrefix) {
        LinkedHashSet filteredClasses = new LinkedHashSet();
        Set<Class<ICodeType<?, ?>>> classes = ((ICodeService)BEANS.get(ICodeService.class)).getAllCodeTypeClasses();
        for (Class clazz : classes) {
            if (!clazz.getName().startsWith(classPrefix)) continue;
            filteredClasses.add(clazz);
        }
        return filteredClasses;
    }
}

