/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeCacheEntryFilter;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeCacheKey;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;

@ApplicationScoped
public class CodeTypeCacheUtility {
    public <T extends ICodeType<?, ?>> CodeTypeCacheKey createCacheKey(Class<T> type) {
        if (type == null) {
            return null;
        }
        return new CodeTypeCacheKey(this.resolveCodeTypeClass(type));
    }

    public <T extends ICodeType<?, ?>> CodeTypeCacheEntryFilter createEntryFilter(Class<T> type) {
        return new CodeTypeCacheEntryFilter(this.resolveCodeTypeClass(type));
    }

    public <T extends ICodeType<?, ?>> CodeTypeCacheEntryFilter createEntryFilter(List<Class<? extends ICodeType<?, ?>>> types) {
        return new CodeTypeCacheEntryFilter(this.resolveCodeTypeClasses(types));
    }

    protected <T extends ICodeType<?, ?>> Class<T> resolveCodeTypeClass(Class<T> type) {
        if (type == null) {
            return null;
        }
        IBean bean = BEANS.getBeanManager().optBean(type);
        if (bean == null || bean.getBeanClazz() == null) {
            return type;
        }
        Class activeCodeTypeClass = bean.getBeanClazz();
        return activeCodeTypeClass;
    }

    protected List<Class<? extends ICodeType<?, ?>>> resolveCodeTypeClasses(List<Class<? extends ICodeType<?, ?>>> types) {
        ArrayList result = new ArrayList();
        if (types == null) {
            return result;
        }
        for (Class<ICodeType<?, ?>> clazz : types) {
            result.add(this.resolveCodeTypeClass(clazz));
        }
        return result;
    }
}

