/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.util.Set;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.BeanMetaData;
import org.eclipse.scout.rt.platform.IBeanInstanceProducer;
import org.eclipse.scout.rt.platform.IBeanManager;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.IPlatformListener;
import org.eclipse.scout.rt.platform.PlatformEvent;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeClassInventory;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeTypeRegistrator
implements IPlatformListener {
    private static final Logger LOG = LoggerFactory.getLogger(CodeTypeRegistrator.class);

    public void stateChanged(PlatformEvent e) {
        if (e.getState() == IPlatform.State.BeanManagerPrepared) {
            IBeanManager beanManager = e.getSource().getBeanManager();
            Set classes = ((CodeTypeClassInventory)((Object)BEANS.get(CodeTypeClassInventory.class))).getClasses();
            for (Class c : classes) {
                LOG.debug("Register {}", (Object)c.getName());
                beanManager.registerBean(new BeanMetaData(c).withProducer((IBeanInstanceProducer)new CodeTypeProducer()));
            }
            LOG.info("{} code type classes registered.", (Object)classes.size());
        }
    }
}

