/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.prefs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.services.common.prefs.IPreferences;
import org.eclipse.scout.rt.shared.services.common.prefs.IUserPreferencesStorageService;
import org.eclipse.scout.rt.shared.services.common.prefs.Preferences;

public abstract class AbstractUserPreferencesStorageService
implements IUserPreferencesStorageService {
    public static final String USER_PREF_KEY = "org.eclipse.scout.rt.shared.services.common.prefs";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPreferences getPreferences(ISession session, String nodeId) {
        if (session == null) {
            throw new IllegalArgumentException("No user scope available.");
        }
        if (!StringUtility.hasText((CharSequence)nodeId)) {
            throw new IllegalArgumentException("No node ID available.");
        }
        ISession iSession = session;
        synchronized (iSession) {
            Object userPrefs = session.getData(USER_PREF_KEY);
            HashMap<String, IPreferences> allUserPrefs = null;
            if (userPrefs instanceof Map) {
                allUserPrefs = (HashMap<String, IPreferences>)userPrefs;
            } else {
                allUserPrefs = new HashMap<String, IPreferences>();
                session.setData(USER_PREF_KEY, allUserPrefs);
            }
            nodeId = nodeId.trim();
            IPreferences result = (IPreferences)allUserPrefs.get(nodeId);
            if (result == null) {
                result = new Preferences(nodeId, session);
                this.load(this.getUserScope(session), nodeId, result);
                result.remove("eclipse.preferences.version");
                allUserPrefs.put(nodeId, result);
            }
            return result;
        }
    }

    protected String getUserScope(ISession session) {
        String userId = session.getUserId();
        if (StringUtility.hasText((CharSequence)userId)) {
            return userId.trim();
        }
        return "anonymous";
    }

    protected abstract void load(String var1, String var2, IPreferences var3);
}

