/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.prefs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Base64Utility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.services.common.prefs.IPreferenceChangeListener;
import org.eclipse.scout.rt.shared.services.common.prefs.IPreferences;
import org.eclipse.scout.rt.shared.services.common.prefs.IUserPreferencesService;
import org.eclipse.scout.rt.shared.services.common.prefs.IUserPreferencesStorageService;
import org.eclipse.scout.rt.shared.services.common.prefs.PreferenceChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Preferences
implements IPreferences {
    private static final String DELIM = "#delim#";
    public static final int EVENT_KIND_CLEAR = 1;
    public static final int EVENT_KIND_ADD = 2;
    public static final int EVENT_KIND_CHANGE = 4;
    public static final int EVENT_KIND_REMOVE = 8;
    private static final Logger LOG = LoggerFactory.getLogger(Preferences.class);
    private static final long serialVersionUID = 1L;
    private final String m_name;
    private final transient ISession m_session;
    private final Map<String, String> m_prefs;
    private final transient FastListenerList<IPreferenceChangeListener> m_eventListeners;
    private boolean m_dirty;

    protected Preferences(String name, ISession userScope) {
        this(name, userScope, new LinkedHashMap<String, String>(), false);
    }

    protected Preferences(Preferences other) {
        this(other.m_name, other.m_session, other.m_prefs, other.m_dirty);
    }

    protected Preferences(String name, ISession userScope, Map<String, String> prefs, boolean dirty) {
        this.m_name = name;
        this.m_session = userScope;
        this.m_prefs = prefs;
        this.m_eventListeners = new FastListenerList();
        this.m_dirty = dirty;
    }

    private Object readResolve() {
        return new Preferences(this);
    }

    public static IPreferences get(ISession userScope, String nodeId) {
        IUserPreferencesService service = (IUserPreferencesService)BEANS.get(IUserPreferencesService.class);
        if (service == null) {
            LOG.warn("No preferences service could be found!");
            return null;
        }
        return service.getPreferences(userScope, nodeId);
    }

    @Override
    public synchronized boolean flush() {
        if (!this.isDirty()) {
            return false;
        }
        IUserPreferencesStorageService service = (IUserPreferencesStorageService)BEANS.get(IUserPreferencesStorageService.class);
        service.flush(this);
        this.m_dirty = false;
        return true;
    }

    @Override
    public boolean put(String key, String value) {
        return this.putInternal(key, value);
    }

    @Override
    public String get(String key, String defaultValue) {
        String value = this.getInternal(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public boolean putList(String key, List<String> values) {
        if (values == null) {
            throw new IllegalArgumentException("null as values is not allowed.");
        }
        StringBuilder sb = new StringBuilder();
        for (String v : values) {
            sb.append(v).append(DELIM);
        }
        String property = sb.toString();
        return this.putInternal(key, property);
    }

    @Override
    public List<String> getList(String key, List<String> defaultValues) {
        String existingPref = this.getInternal(key);
        if (!StringUtility.isNullOrEmpty((CharSequence)existingPref)) {
            return new ArrayList<String>(Arrays.asList(existingPref.split(DELIM)));
        }
        return defaultValues;
    }

    @Override
    public synchronized boolean remove(String key) {
        if (key == null) {
            throw new IllegalArgumentException("null key is not allowed.");
        }
        String old = this.m_prefs.remove(key);
        if (old != null) {
            this.m_dirty = true;
            PreferenceChangeEvent event = new PreferenceChangeEvent(this, 8, key, old, null);
            this.fireEvent(event);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean clear() {
        if (this.m_prefs.isEmpty()) {
            return false;
        }
        this.m_prefs.clear();
        this.m_dirty = true;
        PreferenceChangeEvent event = new PreferenceChangeEvent(this, 1, null, null, null);
        this.fireEvent(event);
        return true;
    }

    @Override
    public boolean putInt(String key, int value) {
        return this.putInternal(key, Integer.toString(value));
    }

    @Override
    public int getInt(String key, int def) {
        int result = def;
        String value = this.getInternal(key);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid int-value for property '{}' configured: {}", (Object)key, (Object)value);
            }
        }
        return result;
    }

    @Override
    public boolean putLong(String key, long value) {
        return this.putInternal(key, Long.toString(value));
    }

    @Override
    public long getLong(String key, long def) {
        long result = def;
        String value = this.getInternal(key);
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid long-value for property '{}' configured: {}", (Object)key, (Object)value);
            }
        }
        return result;
    }

    @Override
    public boolean putBoolean(String key, boolean value) {
        return this.putInternal(key, String.valueOf(value));
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        boolean result = def;
        String value = this.getInternal(key);
        if (value != null) {
            if ("true".equalsIgnoreCase(value)) {
                result = true;
            } else if ("false".equalsIgnoreCase(value)) {
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean putFloat(String key, float value) {
        return this.putInternal(key, Float.toString(value));
    }

    @Override
    public float getFloat(String key, float def) {
        float result = def;
        String value = this.getInternal(key);
        if (value != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid float-value for property '{}' configured: {}", (Object)key, (Object)value);
            }
        }
        return result;
    }

    @Override
    public boolean putDouble(String key, double value) {
        return this.putInternal(key, Double.toString(value));
    }

    @Override
    public double getDouble(String key, double def) {
        double result = def;
        String value = this.getInternal(key);
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid double-value for property '{}' configured: {}", (Object)key, (Object)value);
            }
        }
        return result;
    }

    @Override
    public boolean putByteArray(String key, byte[] value) {
        String encoded = null;
        if (value != null) {
            encoded = Base64Utility.encode((byte[])value);
        }
        return this.putInternal(key, encoded);
    }

    @Override
    public byte[] getByteArray(String key, byte[] def) {
        byte[] result = def;
        String value = this.getInternal(key);
        if (value != null) {
            result = Base64Utility.decode((String)value);
        }
        return result;
    }

    protected synchronized String getInternal(String key) {
        if (key == null) {
            throw new IllegalArgumentException("null key is not allowed.");
        }
        return this.m_prefs.get(key);
    }

    protected synchronized boolean putInternal(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("null key is not allowed.");
        }
        boolean isRemove = value == null;
        String oldValue = null;
        oldValue = isRemove ? this.m_prefs.remove(key) : this.m_prefs.put(key, value);
        if (ObjectUtility.notEquals((Object)oldValue, (Object)value)) {
            this.m_dirty = true;
            PreferenceChangeEvent event = null;
            if (isRemove) {
                event = new PreferenceChangeEvent(this, 8, key, oldValue, null);
            } else {
                boolean isUpdate = oldValue != null;
                event = isUpdate ? new PreferenceChangeEvent(this, 4, key, oldValue, value) : new PreferenceChangeEvent(this, 2, key, null, value);
            }
            this.fireEvent(event);
            return true;
        }
        return false;
    }

    protected void fireEvent(PreferenceChangeEvent event) {
        this.preferenceChangeListeners().list().forEach(listener -> listener.preferenceChange(event));
    }

    protected synchronized boolean isDirty() {
        return this.m_dirty;
    }

    protected synchronized void setDirty(boolean dirty) {
        this.m_dirty = dirty;
    }

    @Override
    public synchronized Set<String> keys() {
        return new LinkedHashSet<String>(this.m_prefs.keySet());
    }

    @Override
    public String name() {
        return this.m_name;
    }

    @Override
    public ISession userScope() {
        return this.m_session;
    }

    @Override
    public IFastListenerList<IPreferenceChangeListener> preferenceChangeListeners() {
        return this.m_eventListeners;
    }

    @Override
    public synchronized int size() {
        return this.m_prefs.size();
    }
}

