/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.util.List;
import java.util.function.Supplier;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.classid.ITypeWithClassId;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;
import org.eclipse.scout.rt.platform.util.TriState;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRowFetchedCallback;
import org.eclipse.scout.rt.shared.services.lookup.ILookupService;

@ClassId(value="0f461d52-9712-494f-9748-8016e5f4ca5a")
public class LookupCall<KEY_TYPE>
implements ILookupCall<KEY_TYPE>,
ITypeWithClassId {
    private static final long serialVersionUID = 0L;
    private KEY_TYPE m_key;
    private String m_text;
    private String m_all;
    private KEY_TYPE m_rec;
    private Object m_master;
    private TriState m_active;
    private int m_maxRowCount;
    private String m_wildcard = "*";
    private boolean m_multilineText;
    private transient ILookupService<KEY_TYPE> m_serviceCached = this.createLookupService();

    public LookupCall() {
        this.m_active = TriState.UNDEFINED;
        this.m_multilineText = this.getConfiguredMultilineText();
    }

    @ConfigProperty(value="LOOKUP_SERVICE")
    @Order(value=10.0)
    protected Class<? extends ILookupService<KEY_TYPE>> getConfiguredService() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    protected boolean getConfiguredMasterRequired() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    protected boolean getConfiguredMultilineText() {
        return false;
    }

    public String classId() {
        return ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass());
    }

    public ILookupService<KEY_TYPE> getLookupService() {
        if (this.m_serviceCached == null) {
            this.m_serviceCached = this.createLookupService();
        }
        return this.m_serviceCached;
    }

    protected ILookupService<KEY_TYPE> createLookupService() {
        ILookupService s = null;
        if (this.getConfiguredService() != null && (s = (ILookupService)BEANS.get(this.getConfiguredService())) == null) {
            throw new IllegalArgumentException("service " + this.getConfiguredService().getName() + " is either not registered in the clientProxy extension in the plugin.xml or this constructor is called outside the model thread");
        }
        return s;
    }

    @Override
    public KEY_TYPE getKey() {
        return this.m_key;
    }

    public long getKeyAsLong() {
        KEY_TYPE o = this.getKey();
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return 0L;
    }

    @Override
    public void setKey(KEY_TYPE key) {
        this.m_key = key;
    }

    @Override
    public String getText() {
        return this.m_text;
    }

    @Override
    public void setText(String s) {
        this.m_text = s;
    }

    @Override
    public String getAll() {
        return this.m_all;
    }

    @Override
    public void setAll(String s) {
        this.m_all = s;
    }

    @Override
    public KEY_TYPE getRec() {
        return this.m_rec;
    }

    public long getRecAsLong() {
        KEY_TYPE o = this.getRec();
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return 0L;
    }

    @Override
    public void setRec(KEY_TYPE parent) {
        this.m_rec = parent;
    }

    @Override
    public TriState getActive() {
        return this.m_active;
    }

    @Override
    public void setActive(TriState s) {
        if (s == null) {
            s = TriState.UNDEFINED;
        }
        this.m_active = s;
    }

    @Override
    public Object getMaster() {
        return this.m_master;
    }

    public long getMasterAsLong() {
        Object o = this.getMaster();
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return 0L;
    }

    @Override
    public void setMaster(Object master) {
        this.m_master = master;
    }

    @Override
    public int getMaxRowCount() {
        return this.m_maxRowCount;
    }

    @Override
    public void setMaxRowCount(int n) {
        this.m_maxRowCount = n;
    }

    @Override
    public LookupCall<KEY_TYPE> copy() {
        try {
            return (LookupCall)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new PlatformException("Could not clone lookup call instance", new Object[]{e});
        }
    }

    public int hashCode() {
        return (this.m_key != null ? this.m_key.hashCode() : 0) ^ (this.m_text != null ? this.m_text.hashCode() : 0) ^ (this.m_all != null ? this.m_all.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        LookupCall other = (LookupCall)obj;
        if (this.m_serviceCached != null && other.m_serviceCached != null && this.m_serviceCached != other.m_serviceCached) {
            return false;
        }
        if (!(this.m_key == other.m_key || this.m_key != null && this.m_key.equals(other.m_key))) {
            return false;
        }
        if (!(this.m_text == other.m_text || this.m_text != null && this.m_text.equals(other.m_text))) {
            return false;
        }
        if (!(this.m_all == other.m_all || this.m_all != null && this.m_all.equals(other.m_all))) {
            return false;
        }
        if (!(this.m_rec == other.m_rec || this.m_rec != null && this.m_rec.equals(other.m_rec))) {
            return false;
        }
        if (!(this.m_master == other.m_master || this.m_master != null && this.m_master.equals(other.m_master))) {
            return false;
        }
        if (!(this.m_active == other.m_active || this.m_active != null && this.m_active.equals((Object)other.m_active))) {
            return false;
        }
        return this.m_maxRowCount == other.m_maxRowCount;
    }

    @Override
    public void setWildcard(String wildcard) {
        this.m_wildcard = Assertions.assertNotNullOrEmpty((String)wildcard, (String)"Wildcard must not be null nor empty", (Object[])new Object[0]);
    }

    @Override
    public String getWildcard() {
        return this.m_wildcard;
    }

    @Override
    public void setMultilineText(boolean b) {
        this.m_multilineText = b;
    }

    @Override
    public boolean isMultilineText() {
        return this.m_multilineText;
    }

    @Override
    public List<? extends ILookupRow<KEY_TYPE>> getDataByKey() {
        if (this.getKey() != null && this.getLookupService() != null) {
            return this.getLookupService().getDataByKey(this);
        }
        return CollectionUtility.emptyArrayList();
    }

    @Override
    public IFuture<Void> getDataByKeyInBackground(RunContext runContext, ILookupRowFetchedCallback<KEY_TYPE> callback) {
        return this.loadDataInBackground(this::getDataByKey, runContext, callback);
    }

    @Override
    public List<? extends ILookupRow<KEY_TYPE>> getDataByText() {
        boolean masterValid;
        boolean bl = masterValid = !this.getConfiguredMasterRequired() || this.getMaster() != null;
        if (masterValid && this.getLookupService() != null) {
            return this.getLookupService().getDataByText(this);
        }
        return CollectionUtility.emptyArrayList();
    }

    @Override
    public IFuture<Void> getDataByTextInBackground(RunContext runContext, ILookupRowFetchedCallback<KEY_TYPE> callback) {
        return this.loadDataInBackground(this::getDataByText, runContext, callback);
    }

    @Override
    public List<? extends ILookupRow<KEY_TYPE>> getDataByAll() {
        boolean masterValid;
        boolean bl = masterValid = !this.getConfiguredMasterRequired() || this.getMaster() != null;
        if (masterValid && this.getLookupService() != null) {
            return this.getLookupService().getDataByAll(this);
        }
        return CollectionUtility.emptyArrayList();
    }

    @Override
    public IFuture<Void> getDataByAllInBackground(RunContext runContext, ILookupRowFetchedCallback<KEY_TYPE> callback) {
        return this.loadDataInBackground(this::getDataByAll, runContext, callback);
    }

    @Override
    public List<? extends ILookupRow<KEY_TYPE>> getDataByRec() {
        if (this.getLookupService() != null) {
            return this.getLookupService().getDataByRec(this);
        }
        return CollectionUtility.emptyArrayList();
    }

    @Override
    public IFuture<Void> getDataByRecInBackground(RunContext runContext, ILookupRowFetchedCallback<KEY_TYPE> callback) {
        return this.loadDataInBackground(this::getDataByRec, runContext, callback);
    }

    protected IFuture<Void> loadDataInBackground(Supplier<List<? extends ILookupRow<KEY_TYPE>>> supplier, RunContext runContext, ILookupRowFetchedCallback<KEY_TYPE> callback) {
        return Jobs.schedule(() -> this.loadData(supplier, callback), (JobInput)Jobs.newInput().withRunContext(runContext).withName("Fetching lookup data [lookupCall={}]", new Object[]{this.getClass().getName()}));
    }

    protected void loadData(Supplier<List<? extends ILookupRow<KEY_TYPE>>> supplier, ILookupRowFetchedCallback<KEY_TYPE> callback) {
        try {
            callback.onSuccess(supplier.get());
        }
        catch (RuntimeException e) {
            callback.onFailure(e);
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.attr("key", this.m_key, false);
        builder.attr("text", this.m_text, false);
        builder.attr("all", this.m_all, false);
        builder.attr("rec", this.m_rec, false);
        builder.attr("master", this.m_master, false);
        builder.attr("maxRowCount", this.m_maxRowCount);
        return builder.toString();
    }
}

