/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.shared.servicetunnel.AbstractServiceTunnelContentHandler;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=5010.0)
public class BinaryServiceTunnelContentHandler
extends AbstractServiceTunnelContentHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryServiceTunnelContentHandler.class);
    private static final String CONTENT_TYPE = "application/octet-stream";
    private Boolean m_receivedCompressed;

    @Override
    public String getContentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void writeRequest(OutputStream out, ServiceTunnelRequest msg) throws IOException {
        this.writeData(out, msg);
    }

    @Override
    public ServiceTunnelRequest readRequest(InputStream in) throws IOException, ClassNotFoundException {
        return this.readData(in, ServiceTunnelRequest.class);
    }

    @Override
    public void writeResponse(OutputStream out, ServiceTunnelResponse msg) throws IOException {
        this.writeData(out, msg);
    }

    @Override
    public ServiceTunnelResponse readResponse(InputStream in) throws IOException, ClassNotFoundException {
        return this.readData(in, ServiceTunnelResponse.class);
    }

    private void writeData(OutputStream out, Object msg) throws IOException {
        Deflater deflater = null;
        boolean compressed = this.isUseCompression();
        try {
            try {
                out.write(compressed ? 1 : 0);
                if (compressed) {
                    deflater = new Deflater(1);
                    out = new DeflaterOutputStream(out, deflater);
                }
                this.getObjectSerializer().serialize(out, msg);
            }
            catch (NotSerializableException e) {
                LOG.error("Error serializing data '{}'", msg);
                throw e;
            }
        }
        finally {
            if (deflater != null) {
                try {
                    deflater.end();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private <T> T readData(InputStream in, Class<T> clazz) throws IOException, ClassNotFoundException {
        Inflater inflater = null;
        boolean compressed = in.read() == 1;
        this.m_receivedCompressed = compressed;
        if (compressed) {
            inflater = new Inflater();
            in = new InflaterInputStream(in, inflater);
        }
        Object object = this.getObjectSerializer().deserialize(in, clazz);
        return (T)object;
        finally {
            if (inflater != null) {
                try {
                    inflater.end();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected boolean isUseCompression() {
        if (this.isSendCompressed() != null) {
            return this.isSendCompressed();
        }
        if (this.m_receivedCompressed != null) {
            return this.m_receivedCompressed;
        }
        return true;
    }
}

