/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class DebugOutputStream
extends OutputStream {
    private final OutputStream m_out;
    private final ByteArrayOutputStream m_debugOut;
    private int m_lastWrittenCharacter;
    private Throwable m_lastThrownException;

    public DebugOutputStream(OutputStream out) {
        this.m_out = out;
        this.m_debugOut = new ByteArrayOutputStream();
    }

    public String getContent(String encoding) throws UnsupportedEncodingException {
        return new String(this.m_debugOut.toByteArray(), encoding);
    }

    @Override
    public void write(int b) throws IOException {
        this.m_lastWrittenCharacter = b;
        try {
            this.m_out.write(this.m_lastWrittenCharacter);
            this.m_debugOut.write((char)this.m_lastWrittenCharacter);
        }
        catch (IOException ioe) {
            this.m_lastThrownException = ioe;
        }
    }

    @Override
    public void flush() throws IOException {
        this.m_out.flush();
    }

    @Override
    public void close() throws IOException {
        this.m_out.close();
        this.m_debugOut.close();
    }

    public int getLastWrittenCharacter() {
        return this.m_lastWrittenCharacter;
    }

    public Throwable getLastThrownException() {
        return this.m_lastThrownException;
    }
}

