/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import java.lang.reflect.Method;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.IBeanInstanceProducer;
import org.eclipse.scout.rt.platform.interceptor.DecoratingProxy;
import org.eclipse.scout.rt.platform.interceptor.IInstanceInvocationHandler;
import org.eclipse.scout.rt.platform.util.VerboseUtility;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTunnelProxyProducer<T>
implements IBeanInstanceProducer<T>,
IInstanceInvocationHandler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceTunnelProxyProducer.class);
    private final DecoratingProxy<T> m_proxy;
    private final Class<?> m_interfaceClass;

    public ServiceTunnelProxyProducer(Class<?> interfaceClass) {
        this.m_interfaceClass = interfaceClass;
        this.m_proxy = DecoratingProxy.newInstance((IInstanceInvocationHandler)this, (Class[])new Class[]{interfaceClass});
    }

    public T produce(IBean<T> bean) {
        return (T)this.m_proxy.getProxy();
    }

    public Object invoke(T instance, Method method, Object[] args) throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Tunnel call to {}.{}({})", new Object[]{this.getInterfaceClass(), method.getName(), VerboseUtility.dumpObjects((Object[])args)});
        }
        return ((IServiceTunnel)BEANS.get(IServiceTunnel.class)).invokeService(this.getInterfaceClass(), method, args);
    }

    protected Class<?> getInterfaceClass() {
        return this.m_interfaceClass;
    }
}

