/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.util.Base64Utility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.servicetunnel.AbstractServiceTunnelContentHandler;
import org.eclipse.scout.rt.shared.servicetunnel.DebugInputStream;
import org.eclipse.scout.rt.shared.servicetunnel.DebugOutputStream;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=5100.0)
public class SoapServiceTunnelContentHandler
extends AbstractServiceTunnelContentHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SoapServiceTunnelContentHandler.class);
    private static final Pattern BEGIN_DATA_TAG = Pattern.compile("[<]([a-zA-Z0-9]+:)?data\\s*>");
    private static final Pattern END_DATA_TAG = Pattern.compile("[<][/]([a-zA-Z0-9]+:)?data\\s*>");
    private static final Pattern COMPRESSED_ATTRIBUTE = Pattern.compile("compressed\\s*=\\s*\"(true|false)\"");
    private static final String CONTENT_TYPE = "text/xml";
    private String m_originAddress;
    private Boolean m_receivedCompressed;

    @Override
    public void initialize() {
        super.initialize();
        try {
            this.m_originAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (RuntimeException | UnknownHostException e) {
            LOG.warn("Could not determine local ip address", (Throwable)e);
        }
    }

    @Override
    public String getContentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void writeRequest(OutputStream stream, ServiceTunnelRequest msg) throws IOException {
        boolean debugEnabled = LOG.isDebugEnabled();
        if (debugEnabled) {
            stream = new DebugOutputStream(stream);
        }
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (OutputStreamWriter out = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
                boolean compressed = this.isUseCompression();
                out.write("<soapenv:Envelope soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:wsse=\"http://schemas.xmlsoap.org/ws/2002/04/secext\">\n");
                out.write("<soapenv:Body>\n");
                out.write("  <request compressed=\"");
                out.write(Boolean.toString(compressed));
                out.write("\" locale=\"");
                out.write(msg.getLocale().toString());
                out.write("\" service=\"");
                out.write(msg.getServiceInterfaceClassName());
                out.write("\" operation=\"");
                out.write(msg.getOperation());
                out.write("\"/>\n");
                out.write("  <data>");
                long y = System.nanoTime();
                this.setData(out, msg, compressed);
                y = System.nanoTime() - y;
                if (debugEnabled) {
                    LOG.debug("message encoding took {} nanoseconds", (Object)y);
                }
                out.write("</data>\n");
                out.write("  <info");
                out.write(" origin=\"" + this.m_originAddress + "\"");
                out.write("/>\n");
                out.write("</soapenv:Body>");
                out.write("</soapenv:Envelope>");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (debugEnabled) {
                String sentData = ((DebugOutputStream)stream).getContent(StandardCharsets.UTF_8.name());
                int lastWrittenCharacter = ((DebugOutputStream)stream).getLastWrittenCharacter();
                Throwable lastThrownException = ((DebugOutputStream)stream).getLastThrownException();
                LOG.debug("lastWrittenCharacter={}, lastThrownException={}, sentData: {}", new Object[]{lastWrittenCharacter, lastThrownException, sentData});
            }
            throw throwable;
        }
        if (debugEnabled) {
            String sentData = ((DebugOutputStream)stream).getContent(StandardCharsets.UTF_8.name());
            int lastWrittenCharacter = ((DebugOutputStream)stream).getLastWrittenCharacter();
            Throwable lastThrownException = ((DebugOutputStream)stream).getLastThrownException();
            LOG.debug("lastWrittenCharacter={}, lastThrownException={}, sentData: {}", new Object[]{lastWrittenCharacter, lastThrownException, sentData});
        }
    }

    @Override
    public void writeResponse(OutputStream stream, ServiceTunnelResponse msg) throws IOException {
        boolean debugEnabled = LOG.isDebugEnabled();
        if (debugEnabled) {
            stream = new DebugOutputStream(stream);
        }
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (OutputStreamWriter out = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
                boolean compressed = this.isUseCompression();
                out.write("<soapenv:Envelope soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">\n");
                out.write("<soapenv:Body>\n");
                if (msg.getException() == null) {
                    out.write("  <response status=\"OK\"");
                    Object x = msg.getData();
                    if (x != null) {
                        out.write(" type=\"" + x.getClass().getSimpleName() + "\"");
                    } else {
                        out.write(" type=\"\"");
                    }
                    out.write(" compressed=\"" + compressed + "\"");
                    out.write("/>\n");
                } else {
                    out.write("  <response status=\"ERROR\"");
                    out.write(" compressed=\"" + compressed + "\"");
                    out.write(">\n");
                    out.write("    <exception type=\"" + msg.getException().getClass().getSimpleName() + "\">");
                    out.write(msg.getException().getMessage());
                    out.write("</exception>\n");
                    out.write("  </response>\n");
                }
                out.write("  <data>");
                long y = System.nanoTime();
                this.setData(out, msg, compressed);
                y = System.nanoTime() - y;
                if (debugEnabled) {
                    LOG.debug("message encoding took {} nanoseconds", (Object)y);
                }
                out.write("</data>\n");
                out.write("  <info");
                out.write(" origin=\"" + this.m_originAddress + "\"");
                out.write("/>\n");
                out.write("</soapenv:Body>");
                out.write("</soapenv:Envelope>");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (debugEnabled) {
                String sentData = ((DebugOutputStream)stream).getContent(StandardCharsets.UTF_8.name());
                int lastWrittenCharacter = ((DebugOutputStream)stream).getLastWrittenCharacter();
                Throwable lastThrownException = ((DebugOutputStream)stream).getLastThrownException();
                LOG.debug("lastWrittenCharacter={}, lastThrownException={}, sentData: {}", new Object[]{lastWrittenCharacter, lastThrownException, sentData});
            }
            throw throwable;
        }
        if (debugEnabled) {
            String sentData = ((DebugOutputStream)stream).getContent(StandardCharsets.UTF_8.name());
            int lastWrittenCharacter = ((DebugOutputStream)stream).getLastWrittenCharacter();
            Throwable lastThrownException = ((DebugOutputStream)stream).getLastThrownException();
            LOG.debug("lastWrittenCharacter={}, lastThrownException={}, sentData: {}", new Object[]{lastWrittenCharacter, lastThrownException, sentData});
        }
    }

    protected void setData(Writer writer, Object msg, boolean compressed) throws IOException {
        Deflater deflater = null;
        try {
            try {
                ByteArrayOutputStream bos;
                OutputStream out = bos = new ByteArrayOutputStream();
                if (compressed) {
                    deflater = new Deflater(1);
                    out = new DeflaterOutputStream((OutputStream)bos, deflater);
                }
                this.getObjectSerializer().serialize(out, msg);
                String base64Data = StringUtility.wrapText((String)Base64Utility.encode((byte[])bos.toByteArray()), (int)10000);
                writer.write(base64Data);
            }
            catch (NotSerializableException e) {
                LOG.error("Error serializing data '{}'", msg);
                throw e;
            }
        }
        finally {
            if (deflater != null) {
                try {
                    deflater.end();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public ServiceTunnelRequest readRequest(InputStream in) throws IOException, ClassNotFoundException {
        return (ServiceTunnelRequest)this.read(in);
    }

    @Override
    public ServiceTunnelResponse readResponse(InputStream in) throws IOException, ClassNotFoundException {
        return (ServiceTunnelResponse)this.read(in);
    }

    protected Object read(InputStream in) throws IOException, ClassNotFoundException {
        boolean compressed;
        String dataPart;
        block9: {
            if (LOG.isDebugEnabled()) {
                in = new DebugInputStream(in);
            }
            dataPart = null;
            compressed = true;
            try {
                int ch;
                BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                StringBuilder buf = new StringBuilder();
                while ((ch = ((Reader)r).read()) >= 0) {
                    buf.append((char)ch);
                }
                String xml = buf.toString();
                buf.setLength(0);
                Matcher mc = COMPRESSED_ATTRIBUTE.matcher(xml);
                if (mc.find()) {
                    compressed = "true".equals(mc.group(1));
                    this.m_receivedCompressed = compressed;
                }
                Matcher m1 = BEGIN_DATA_TAG.matcher(xml);
                Matcher m2 = END_DATA_TAG.matcher(xml);
                int lastMatchingIndex = 0;
                if (m1.find() && m2.find(m1.start())) {
                    do {
                        lastMatchingIndex = m2.start();
                    } while (m2.find());
                    dataPart = xml.substring(m1.end(), lastMatchingIndex);
                    break block9;
                }
                throw new IOException("missing a data tag");
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    String receivedData = ((DebugInputStream)in).getContent(StandardCharsets.UTF_8.name());
                    int lastReadCharacter = ((DebugInputStream)in).getLastReadCharacter();
                    Throwable lastThrownException = ((DebugInputStream)in).getLastThrownException();
                    LOG.debug("lastReadCharacter={}, lastThrownException={}, receivedData:\n{}", new Object[]{lastReadCharacter, lastThrownException, receivedData});
                }
                throw throwable;
            }
        }
        if (LOG.isDebugEnabled()) {
            String receivedData = ((DebugInputStream)in).getContent(StandardCharsets.UTF_8.name());
            int lastReadCharacter = ((DebugInputStream)in).getLastReadCharacter();
            Throwable lastThrownException = ((DebugInputStream)in).getLastThrownException();
            LOG.debug("lastReadCharacter={}, lastThrownException={}, receivedData:\n{}", new Object[]{lastReadCharacter, lastThrownException, receivedData});
        }
        long y = System.nanoTime();
        Object res = this.getData(dataPart, compressed);
        y = System.nanoTime() - y;
        LOG.debug("message decoding took {} nanoseconds", (Object)y);
        return res;
    }

    protected Object getData(String dataPart, boolean compressed) throws IOException, ClassNotFoundException {
        Inflater inflater = null;
        try {
            InputStream in = new ByteArrayInputStream(Base64Utility.decode((String)dataPart));
            if (compressed) {
                inflater = new Inflater();
                in = new InflaterInputStream(in, inflater);
            }
            Object object = this.getObjectSerializer().deserialize(in, null);
            return object;
        }
        finally {
            if (inflater != null) {
                try {
                    inflater.end();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected boolean isUseCompression() {
        if (this.isSendCompressed() != null) {
            return this.isSendCompressed();
        }
        if (this.m_receivedCompressed != null) {
            return this.m_receivedCompressed;
        }
        return true;
    }
}

