/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.HexUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class DefaultAuthToken {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthToken.class);
    private String m_userId;
    private long m_validUntil;
    private List<String> m_customArgs;
    private byte[] m_signature;

    public String getUserId() {
        return this.m_userId;
    }

    public String getUserIdOrAnonymous() {
        return StringUtility.hasText((CharSequence)this.m_userId) ? this.m_userId : "anonymous";
    }

    public DefaultAuthToken withUserId(String userId) {
        this.m_userId = userId;
        return this;
    }

    public long getValidUntil() {
        return this.m_validUntil;
    }

    public DefaultAuthToken withValidUntil(long validUntil) {
        this.m_validUntil = validUntil;
        return this;
    }

    protected boolean verifyUser(DefaultAuthToken token) {
        return StringUtility.hasText((CharSequence)token.getUserId());
    }

    protected boolean verifyValidUntil(DefaultAuthToken token) {
        return System.currentTimeMillis() < token.getValidUntil();
    }

    public List<String> getCustomArgs() {
        return this.m_customArgs;
    }

    public DefaultAuthToken withCustomArgs(List<String> customArgs) {
        this.m_customArgs = customArgs;
        return this;
    }

    public DefaultAuthToken withCustomArgs(String ... customArgs) {
        if (customArgs != null && customArgs.length > 0) {
            this.m_customArgs = new ArrayList<String>(Arrays.asList(customArgs));
        }
        return this;
    }

    public byte[] getSignature() {
        return this.m_signature;
    }

    public DefaultAuthToken withSignature(byte[] signature) {
        this.m_signature = signature;
        return this;
    }

    protected char partsDelimiter() {
        return ';';
    }

    public DefaultAuthToken read(String token) {
        if (!StringUtility.hasText((CharSequence)token)) {
            return this;
        }
        String[] parts = token.split(Pattern.quote("" + this.partsDelimiter()));
        if (parts == null || parts.length < 3) {
            return this;
        }
        try {
            this.withUserId(new String(HexUtility.decode((String)parts[0]), StandardCharsets.UTF_8));
            this.withValidUntil(Long.parseLong(parts[1], 16));
            if (parts.length > 3) {
                int numberOfCustomArgs = parts.length - 1;
                ArrayList<String> customArgs = new ArrayList<String>(numberOfCustomArgs);
                int i = 2;
                while (i < numberOfCustomArgs) {
                    customArgs.add(new String(HexUtility.decode((String)parts[i]), StandardCharsets.UTF_8));
                    ++i;
                }
                this.withCustomArgs(customArgs);
            }
            try {
                this.withSignature(HexUtility.decode((String)parts[parts.length - 1]));
            }
            catch (RuntimeException e) {
                LOG.debug("Could not decode hex string", (Throwable)e);
            }
        }
        catch (Exception ex) {
            throw new PlatformException("unexpected behaviour", new Object[]{ex});
        }
        return this;
    }

    /*
     * Loose catch block
     */
    public String write(boolean withSignature) {
        char partsDelimiter = this.partsDelimiter();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                String string;
                HexUtility.HexOutputStream hex;
                ByteArrayOutputStream bytes;
                block21: {
                    block20: {
                        bytes = new ByteArrayOutputStream();
                        hex = new HexUtility.HexOutputStream((OutputStream)bytes);
                        hex.write(this.getUserIdOrAnonymous().getBytes(StandardCharsets.UTF_8));
                        bytes.write(partsDelimiter);
                        bytes.write(Long.toHexString(this.getValidUntil()).getBytes());
                        if (this.getCustomArgs() != null) {
                            for (String arg : this.getCustomArgs()) {
                                bytes.write(partsDelimiter);
                                hex.write(arg.getBytes(StandardCharsets.UTF_8));
                            }
                        }
                        byte[] signature = this.getSignature();
                        if (withSignature && signature != null && signature.length > 0) {
                            bytes.write(partsDelimiter);
                            hex.write(signature);
                        }
                        string = bytes.toString(StandardCharsets.UTF_8.name());
                        if (hex == null) break block20;
                        hex.close();
                    }
                    if (bytes == null) break block21;
                    bytes.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (hex != null) {
                                hex.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (bytes != null) {
                                bytes.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new PlatformException("unexpected behaviour", new Object[]{ex});
        }
    }

    public String toString() {
        return this.write(true);
    }
}

