/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel.http;

import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Principal;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.security.JwtPrincipal;
import org.eclipse.scout.rt.platform.security.SamlPrincipal;
import org.eclipse.scout.rt.platform.security.SecurityUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.security.IAccessControlService;
import org.eclipse.scout.rt.shared.SharedConfigProperties;
import org.eclipse.scout.rt.shared.servicetunnel.http.DefaultAuthToken;

@ApplicationScoped
public class DefaultAuthTokenSigner {
    public static final String JWT_IDENTIFIER = "jwt";
    public static final String SAML_IDENTIFIER = "saml";

    protected long getTokenTimeToLive() {
        return (Long)CONFIG.getPropertyValue(SharedConfigProperties.AuthTokenTimeToLiveProperty.class);
    }

    protected byte[] getPrivateKey() {
        return (byte[])CONFIG.getPropertyValue(SharedConfigProperties.AuthTokenPrivateKeyProperty.class);
    }

    protected String getDefaultUserId() {
        return ((IAccessControlService)BEANS.get(IAccessControlService.class)).getUserIdOfCurrentSubject();
    }

    public boolean isEnabled() {
        return this.getPrivateKey() != null;
    }

    public <T extends DefaultAuthToken> T createDefaultSignedToken(Class<T> tokenClazz) {
        if (!this.isEnabled()) {
            return null;
        }
        String userId = this.getDefaultUserId();
        if (StringUtility.isNullOrEmpty((CharSequence)userId)) {
            return null;
        }
        DefaultAuthToken token = (DefaultAuthToken)BEANS.get(tokenClazz);
        token.withUserId(userId);
        this.appendCustomArgs(token);
        return (T)this.sign(token);
    }

    protected void appendCustomArgs(DefaultAuthToken token) {
        Principal principal = this.selectUserPrincipal();
        if (principal instanceof JwtPrincipal) {
            JwtPrincipal jwt = (JwtPrincipal)principal;
            token.withCustomArgs(JWT_IDENTIFIER, jwt.getJwtTokenString(), jwt.getAccessToken(), jwt.getRefreshToken());
        } else if (principal instanceof SamlPrincipal) {
            SamlPrincipal saml = (SamlPrincipal)principal;
            token.withCustomArgs(SAML_IDENTIFIER, saml.getSessionIndex());
        }
    }

    protected Principal selectUserPrincipal() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            return null;
        }
        return subject.getPrincipals().stream().findFirst().orElse(null);
    }

    public <T extends DefaultAuthToken> T sign(T token) {
        token.withValidUntil(System.currentTimeMillis() + this.getTokenTimeToLive());
        if (this.isEnabled()) {
            token.withSignature(this.signature(token));
        }
        return token;
    }

    protected byte[] signature(DefaultAuthToken token) {
        return SecurityUtility.createSignature((byte[])this.getPrivateKey(), (byte[])token.write(false).getBytes(StandardCharsets.UTF_8));
    }
}

