/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel.http;

import java.nio.charset.StandardCharsets;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.security.SecurityUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.SharedConfigProperties;
import org.eclipse.scout.rt.shared.servicetunnel.http.DefaultAuthToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultAuthTokenVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthTokenVerifier.class);

    public boolean isEnabled() {
        return this.getPublicKey() != null;
    }

    protected byte[] getPublicKey() {
        return (byte[])CONFIG.getPropertyValue(SharedConfigProperties.AuthTokenPublicKeyProperty.class);
    }

    public boolean verify(DefaultAuthToken token) {
        try {
            return token != null && this.verifyUser(token) && this.verifyValidUntil(token) && this.verifySignature(token);
        }
        catch (RuntimeException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed verifying signature of token {}", (Object)token, (Object)e);
            }
            return false;
        }
    }

    protected boolean verifyUser(DefaultAuthToken token) {
        return StringUtility.hasText((CharSequence)token.getUserId());
    }

    protected boolean verifyValidUntil(DefaultAuthToken token) {
        return System.currentTimeMillis() < token.getValidUntil();
    }

    protected boolean verifySignature(DefaultAuthToken token) {
        byte[] signature = token.getSignature();
        if (signature == null) {
            return false;
        }
        byte[] publicKey = this.getPublicKey();
        if (publicKey == null) {
            return false;
        }
        return SecurityUtility.verifySignature((byte[])publicKey, (byte[])token.write(false).getBytes(StandardCharsets.UTF_8), (byte[])signature);
    }
}

