/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.session;

import java.math.BigInteger;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.security.SecurityUtility;
import org.eclipse.scout.rt.security.IAccessControlService;
import org.eclipse.scout.rt.shared.ISession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Sessions {
    private static final Logger LOG = LoggerFactory.getLogger(Sessions.class);

    private Sessions() {
    }

    public static <SESSION extends ISession> SESSION currentSession(Class<SESSION> type) {
        ISession session = ISession.CURRENT.get();
        if (session == null) {
            return null;
        }
        if (!type.isInstance(session)) {
            LOG.debug("Session not of the expected type [session={}, expectedType={}]", (Object)session, type);
            return null;
        }
        return (SESSION)((ISession)type.cast(session));
    }

    public static String randomSessionId() {
        BigInteger randomId = new BigInteger(1, SecurityUtility.createRandomBytes());
        return randomId.toString(32);
    }

    public static String getCurrentUserId() {
        ISession session = ISession.CURRENT.get();
        if (session != null && session.isActive()) {
            return session.getUserId();
        }
        return ((IAccessControlService)BEANS.get(IAccessControlService.class)).getUserIdOfCurrentSubject();
    }
}

