/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui.webresource;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.shared.ui.webresource.AbstractWebResourceResolver;

public class FilesystemWebResourceResolver
extends AbstractWebResourceResolver {
    private final Path m_root = FilesystemWebResourceResolver.findModuleRoot().resolve("dist");

    protected FilesystemWebResourceResolver() {
    }

    @Override
    protected Stream<URL> getResourceImpl(String resourcePath) {
        try {
            return FilesystemWebResourceResolver.resolveUrls(this.m_root, resourcePath);
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    protected static Stream<URL> resolveUrls(Path root, String relPath) {
        return FilesystemWebResourceResolver.resolveUrls(Collections.singleton(root), relPath);
    }

    protected static Stream<URL> resolveUrls(Collection<Path> roots, String relPath) {
        if (roots == null || relPath == null) {
            return Stream.empty();
        }
        return roots.stream().map(root -> root.resolve(relPath)).map(FilesystemWebResourceResolver::toUrl).filter(Objects::nonNull);
    }

    protected static URL toUrl(Path path) {
        if (Files.isReadable(path) && Files.isRegularFile(path, new LinkOption[0])) {
            try {
                return path.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new PlatformException("Invalid URL for path '{}'.", new Object[]{path, e});
            }
        }
        return null;
    }

    protected static Path findModuleRoot() {
        Path resourceRoot;
        String folderName;
        Path workingDir = Paths.get("", new String[0]).toAbsolutePath();
        Path parentDir = workingDir.getParent();
        String appModuleName = folderName = workingDir.getFileName().toString();
        if (folderName.endsWith(".dev") || folderName.endsWith("-dev")) {
            appModuleName = folderName.substring(0, folderName.length() - 4);
        }
        if (Files.isDirectory(resourceRoot = parentDir.resolve(appModuleName), new LinkOption[0]) && Files.isReadable(resourceRoot)) {
            return resourceRoot;
        }
        if (appModuleName.endsWith(".app") || appModuleName.endsWith("-app")) {
            appModuleName = appModuleName.substring(0, appModuleName.length() - 4);
        }
        if (Files.isDirectory(resourceRoot = parentDir.resolve(appModuleName), new LinkOption[0]) && Files.isReadable(resourceRoot)) {
            return resourceRoot;
        }
        return workingDir;
    }
}

