/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui.webresource;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.util.StringUtility;

public final class ScriptRequest {
    public static final String MINIMIZED_URL_KEYWORD = "min";
    public static final Pattern SCRIPT_URL_PATTERN = Pattern.compile("([^\"']*/)([-_.~\\w\\d]+?)(?:-([a-f0-9]+))?(?:\\.(min)?)?\\.(js|css)");
    private final String m_path;
    private final String m_baseName;
    private final String m_fingerprint;
    private final boolean m_minimized;
    private final String m_fileExtension;

    private ScriptRequest(Matcher m) {
        this.m_path = m.group(1);
        this.m_baseName = m.group(2);
        this.m_fingerprint = m.group(3);
        this.m_minimized = MINIMIZED_URL_KEYWORD.equals(m.group(4));
        this.m_fileExtension = m.group(5);
    }

    public static Optional<ScriptRequest> tryParse(String scriptRequestPath) {
        if (!StringUtility.hasText((CharSequence)scriptRequestPath)) {
            return Optional.empty();
        }
        Matcher matcher = SCRIPT_URL_PATTERN.matcher(scriptRequestPath);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        return Optional.of(new ScriptRequest(matcher));
    }

    public static Optional<ScriptRequest> tryParse(String path, String baseName, String fingerprint, boolean min, String extension) {
        return ScriptRequest.tryParse(ScriptRequest.toFullPath(path, baseName, fingerprint, min, extension));
    }

    public String path() {
        return this.m_path;
    }

    public String baseName() {
        return this.m_baseName;
    }

    public String fingerprint() {
        return this.m_fingerprint;
    }

    public boolean minimized() {
        return this.m_minimized;
    }

    public String fileExtension() {
        return this.m_fileExtension;
    }

    public String fullPath() {
        return this.toString(true, true);
    }

    public String lookupPath() {
        return this.toString(false, true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptRequest that = (ScriptRequest)o;
        return this.m_minimized == that.m_minimized && Objects.equals(this.m_path, that.m_path) && Objects.equals(this.m_baseName, that.m_baseName) && Objects.equals(this.m_fingerprint, that.m_fingerprint) && Objects.equals(this.m_fileExtension, that.m_fileExtension);
    }

    public int hashCode() {
        return Objects.hash(this.m_path, this.m_baseName, this.m_fingerprint, this.m_minimized, this.m_fileExtension);
    }

    public String toString() {
        return this.fullPath();
    }

    public String toString(boolean fingerprint, boolean min) {
        return this.toString(true, true, fingerprint, min, true);
    }

    public String toString(boolean path, boolean baseName, boolean fingerprint, boolean min, boolean extension) {
        return ScriptRequest.toFullPath(path ? this.path() : null, baseName ? this.baseName() : null, fingerprint ? this.fingerprint() : null, min && this.minimized(), extension ? this.fileExtension() : null);
    }

    public static String toFullPath(String path, String baseName, String fingerprint, boolean min, String extension) {
        StringBuilder result = new StringBuilder();
        if (path != null && !"./".equals(path)) {
            result.append(path);
        }
        if (baseName != null) {
            result.append(baseName);
        }
        if (StringUtility.hasText((CharSequence)fingerprint)) {
            result.append('-').append(fingerprint);
        }
        if (min) {
            result.append('.').append(MINIMIZED_URL_KEYWORD);
        }
        if (StringUtility.hasText((CharSequence)extension)) {
            result.append('.').append(extension);
        }
        return result.toString();
    }
}

