/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui.webresource;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.FinalValue;
import org.eclipse.scout.rt.platform.util.ImmutablePair;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.Pair;
import org.eclipse.scout.rt.platform.util.StreamUtility;
import org.eclipse.scout.rt.shared.ui.webresource.AbstractWebResourceResolver;
import org.eclipse.scout.rt.shared.ui.webresource.FileListParser;
import org.eclipse.scout.rt.shared.ui.webresource.WebResourceDescriptor;
import org.eclipse.scout.rt.shared.ui.webresource.WebResources;

@ApplicationScoped
public class ScriptResourceIndexes {
    public static final String INDEX_FILE_NAME = "file-list";
    private static final LazyValue<ScriptResourceIndexes> INSTANCE = new LazyValue(ScriptResourceIndexes.class);
    private final FinalValue<Map<String, Set<String>>> m_devEntryPointToAssets = new FinalValue();
    private final FinalValue<Map<String, Set<String>>> m_prodEntryPointToAssets = new FinalValue();
    private final FinalValue<Map<String, String>> m_assetNameToMinifiedName = new FinalValue();

    public static Set<String> getAssetsForEntryPoint(String entryPoint, boolean minified) {
        return ((ScriptResourceIndexes)INSTANCE.get()).getAssets(entryPoint, minified);
    }

    public static String getMinifiedPath(String path) {
        return ((ScriptResourceIndexes)INSTANCE.get()).toMinifiedPath(path);
    }

    public Set<String> getAssets(String entryPoint, boolean minified) {
        Set<String> assets = this.entryPointToAssetsIndex(minified).get(entryPoint);
        if (assets == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(assets);
    }

    public String toMinifiedPath(String path) {
        if (INDEX_FILE_NAME.equals(path)) {
            return path;
        }
        String indexValue = this.assetNameToMinifiedNameIndex().get(AbstractWebResourceResolver.stripLeadingSlash(path));
        if (indexValue == null) {
            return path;
        }
        return indexValue;
    }

    protected Map<String, Set<String>> entryPointToAssetsIndex(boolean minified) {
        FinalValue<Map<String, Set<String>>> index = minified ? this.m_prodEntryPointToAssets : this.m_devEntryPointToAssets;
        return (Map)index.setIfAbsentAndGet(() -> this.createIndexEntryPointToAssets(minified));
    }

    protected Map<String, String> assetNameToMinifiedNameIndex() {
        return (Map)this.m_assetNameToMinifiedName.setIfAbsentAndGet(this::createIndexAssetNameToMinifiedName);
    }

    protected Map<String, String> createIndexAssetNameToMinifiedName() {
        return this.getFileListEntries(true).collect(Collectors.toMap(this::getEntryBasePath, FileListParser.FileListEntry::rawLine, StreamUtility.ignoringMerger()));
    }

    protected String getEntryBasePath(FileListParser.FileListEntry entry) {
        return entry.asset().toString(true, true, false, false, true);
    }

    protected Map<String, Set<String>> createIndexEntryPointToAssets(boolean minified) {
        return this.getFileListEntries(minified).flatMap(entry -> entry.entryPoints().stream().map(ep -> new ImmutablePair(ep, (Object)entry.rawLine()))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toSet())));
    }

    public Stream<FileListParser.FileListEntry> getFileListEntries(boolean minified) {
        return WebResources.resolveScriptResources(INDEX_FILE_NAME, minified, null).stream().map(WebResourceDescriptor::getUrl).flatMap(this::parseFileListEntries);
    }

    protected Stream<FileListParser.FileListEntry> parseFileListEntries(URL url) {
        return ((FileListParser)BEANS.get(FileListParser.class)).parse(url);
    }
}

