/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui.webresource;

import java.net.URL;
import java.util.Objects;
import org.eclipse.scout.rt.platform.util.Assertions;

public class WebResourceDescriptor {
    private final URL m_url;
    private final String m_requestPath;
    private final String m_resolvedPath;

    public WebResourceDescriptor(URL url, String requestPath, String resolvedPath) {
        this.m_url = (URL)Assertions.assertNotNull((Object)url);
        this.m_requestPath = (String)Assertions.assertNotNull((Object)requestPath);
        this.m_resolvedPath = (String)Assertions.assertNotNull((Object)resolvedPath);
    }

    public URL getUrl() {
        return this.m_url;
    }

    public String getRequestPath() {
        return this.m_requestPath;
    }

    public String getResolvedPath() {
        return this.m_resolvedPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebResourceDescriptor that = (WebResourceDescriptor)o;
        return Objects.equals(this.m_url, that.m_url) && Objects.equals(this.m_requestPath, that.m_requestPath) && Objects.equals(this.m_resolvedPath, that.m_resolvedPath);
    }

    public int hashCode() {
        return Objects.hash(this.m_url, this.m_requestPath, this.m_resolvedPath);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '[' + "url=" + this.m_url + ", requestPath='" + this.m_requestPath + '\'' + ", resolvedPath='" + this.m_resolvedPath + '\'' + ']';
    }
}

