/*
 * Copyright (c) 2010-2015 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 */
package org.eclipse.scout.rt.shared.services.common.code;

import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.IBeanInstanceProducer;

/**
 * Producer for code type instances. Simply delegates to {@link ICodeService}
 */
public class CodeTypeProducer implements IBeanInstanceProducer<ICodeType<?, ?>> {

  @Override
  public ICodeType<?, ?> produce(IBean<ICodeType<?, ?>> bean) {
    return BEANS.get(ICodeService.class).getCodeType(bean.getBeanClazz());
  }

}
