/*
 * Copyright (c) 2014-2017 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.colorfield;

import org.eclipse.scout.rt.client.ui.form.fields.colorfield.IColorField;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonValueField;

/**
 * Currently not supported by Html UI. JsonColorField.java and ColorField.js are just stub implementations.
 *
 * @since 5.2
 */
public class JsonColorField<COLOR_FIELD extends IColorField> extends JsonValueField<COLOR_FIELD> {

  public JsonColorField(COLOR_FIELD model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
    super(model, uiSession, id, parent);
  }

  @Override
  public String getObjectType() {
    return "ColorField";
  }

}
