/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html;

import javax.servlet.http.HttpSession;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.server.commons.HttpSessionMutex;
import org.eclipse.scout.rt.ui.html.ISessionStore;
import org.eclipse.scout.rt.ui.html.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HttpSessionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSessionHelper.class);
    public static final String SESSION_STORE_ATTRIBUTE_NAME = "scout.htmlui.httpsession.sessionstore";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISessionStore getSessionStore(HttpSession httpSession) {
        ISessionStore sessionStore = this.getSessionStoreFromHttpSession((HttpSession)Assertions.assertNotNull((Object)httpSession));
        if (sessionStore != null) {
            return sessionStore;
        }
        Object object = HttpSessionMutex.of((HttpSession)httpSession);
        synchronized (object) {
            sessionStore = this.getSessionStoreFromHttpSession(httpSession);
            if (sessionStore != null) {
                return sessionStore;
            }
            sessionStore = this.createSessionStore(httpSession);
            httpSession.setAttribute(SESSION_STORE_ATTRIBUTE_NAME, (Object)sessionStore);
            LOG.debug("Created new session store for HTTP session with ID {}", (Object)httpSession.getId());
            return sessionStore;
        }
    }

    protected ISessionStore getSessionStoreFromHttpSession(HttpSession httpSession) {
        return (ISessionStore)httpSession.getAttribute(SESSION_STORE_ATTRIBUTE_NAME);
    }

    protected ISessionStore createSessionStore(HttpSession httpSession) {
        return new SessionStore(httpSession);
    }
}

