/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.server.commons.servlet.cache.IHttpResourceCache;
import org.eclipse.scout.rt.ui.html.UiSessionListener;
import org.eclipse.scout.rt.ui.html.UiSessionListeners;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonRequest;
import org.eclipse.scout.rt.ui.html.json.JsonResponse;
import org.eclipse.scout.rt.ui.html.json.JsonStartupRequest;
import org.eclipse.scout.rt.ui.html.res.IUploadable;
import org.json.JSONObject;

@Bean
public interface IUiSession {
    public static final ThreadLocal<IUiSession> CURRENT = new ThreadLocal();
    public static final String PREFERRED_LOCALE_COOKIE_NAME = "scout.preferredLocale";

    public ReentrantLock uiSessionLock();

    public void init(HttpServletRequest var1, HttpServletResponse var2, JsonStartupRequest var3);

    public boolean isInitialized();

    public boolean isPersistent();

    public String getHttpSessionId();

    public String getUiSessionId();

    public String getClientSessionId();

    public IClientSession getClientSession();

    public void touch();

    public long getLastAccessedTime();

    public void dispose();

    public boolean isDisposed();

    public JsonResponse currentJsonResponse();

    public HttpServletRequest currentHttpRequest();

    public HttpServletResponse currentHttpResponse();

    public void confirmResponseProcessed(Long var1);

    public void verifySubject(HttpServletRequest var1);

    public JSONObject processJsonRequest(HttpServletRequest var1, HttpServletResponse var2, JsonRequest var3);

    public JSONObject processFileUpload(HttpServletRequest var1, HttpServletResponse var2, IUploadable var3, List<BinaryResource> var4, Map<String, String> var5);

    public void processCancelRequest();

    public JSONObject processSyncResponseQueueRequest(JsonRequest var1);

    public void logout();

    public String getLogoutRedirectUrl();

    public IJsonAdapter<?> getRootJsonAdapter();

    public String createUniqueId();

    public IJsonAdapter<?> getJsonAdapter(String var1);

    public <M> List<IJsonAdapter<M>> getJsonAdapters(M var1);

    public List<IJsonAdapter<?>> getJsonChildAdapters(IJsonAdapter<?> var1);

    public <M, A extends IJsonAdapter<M>> A getJsonAdapter(M var1, IJsonAdapter<?> var2);

    public <M, A extends IJsonAdapter<M>> A getJsonAdapter(M var1, IJsonAdapter<?> var2, boolean var3);

    public <M, A extends IJsonAdapter<M>> A getOrCreateJsonAdapter(M var1, IJsonAdapter<?> var2);

    public <M, A extends IJsonAdapter<M>> A createJsonAdapter(M var1, IJsonAdapter<?> var2);

    public void registerJsonAdapter(IJsonAdapter<?> var1);

    public void unregisterJsonAdapter(IJsonAdapter<?> var1);

    public void waitForBackgroundJobs(JsonRequest var1, int var2) throws InterruptedException;

    public void sendLocaleChangedEvent(Locale var1);

    public void sendDisposeAdapterEvent(IJsonAdapter<?> var1);

    public void sendReloadPageEvent();

    public void updateTheme(String var1);

    public IHttpResourceCache getHttpResourceCache();

    public UiSessionListeners listeners();

    default public void addListener(UiSessionListener listener, Integer ... eventTypes) {
        this.listeners().add(listener, false, eventTypes);
    }

    default public void removeListener(UiSessionListener listener, Integer ... eventTypes) {
        this.listeners().remove(listener, eventTypes);
    }
}

